package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  EntityName,
  Timestamp,
  ListMaxResults,
  NextToken
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDevicesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListMaxResults] = Optional.Absent,
    latestHeartbeatAfter: Optional[Timestamp] = Optional.Absent,
    modelName: Optional[EntityName] = Optional.Absent,
    deviceFleetName: Optional[EntityName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest = {
    import ListDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        latestHeartbeatAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestHeartbeatAfter)
      .optionallyWith(
        modelName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        deviceFleetName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.deviceFleetName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListDevicesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListDevicesRequest.wrap(buildAwsValue())
}
object ListDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListDevicesRequest =
      zio.aws.sagemaker.model.ListDevicesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        latestHeartbeatAfter.map(value => value),
        modelName.map(value => value),
        deviceFleetName.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListMaxResults]
    def latestHeartbeatAfter: Optional[Timestamp]
    def modelName: Optional[EntityName]
    def deviceFleetName: Optional[EntityName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLatestHeartbeatAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestHeartbeatAfter", latestHeartbeatAfter)
    def getModelName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getDeviceFleetName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("deviceFleetName", deviceFleetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest
  ) extends zio.aws.sagemaker.model.ListDevicesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[ListMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.ListMaxResults(value))
    override val latestHeartbeatAfter: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestHeartbeatAfter())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modelName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val deviceFleetName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceFleetName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest
  ): zio.aws.sagemaker.model.ListDevicesRequest.ReadOnly = new Wrapper(impl)
}
