package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait LineageType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.LineageType
}
object LineageType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.LineageType
  ): zio.aws.sagemaker.model.LineageType = value match {
    case software.amazon.awssdk.services.sagemaker.model.LineageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.LineageType.TRIAL_COMPONENT =>
      val r = TrialComponent
      r
    case software.amazon.awssdk.services.sagemaker.model.LineageType.ARTIFACT =>
      val r = Artifact
      r
    case software.amazon.awssdk.services.sagemaker.model.LineageType.CONTEXT =>
      val r = Context
      r
    case software.amazon.awssdk.services.sagemaker.model.LineageType.ACTION =>
      val r = Action
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.LineageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LineageType =
      software.amazon.awssdk.services.sagemaker.model.LineageType.UNKNOWN_TO_SDK_VERSION
  }
  case object TrialComponent extends zio.aws.sagemaker.model.LineageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LineageType =
      software.amazon.awssdk.services.sagemaker.model.LineageType.TRIAL_COMPONENT
  }
  case object Artifact extends zio.aws.sagemaker.model.LineageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LineageType =
      software.amazon.awssdk.services.sagemaker.model.LineageType.ARTIFACT
  }
  case object Context extends zio.aws.sagemaker.model.LineageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LineageType =
      software.amazon.awssdk.services.sagemaker.model.LineageType.CONTEXT
  }
  case object Action extends zio.aws.sagemaker.model.LineageType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LineageType =
      software.amazon.awssdk.services.sagemaker.model.LineageType.ACTION
  }
}
