package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.LabelCounter
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LabelCountersForWorkteam(
    humanLabeled: Optional[LabelCounter] = Optional.Absent,
    pendingHuman: Optional[LabelCounter] = Optional.Absent,
    total: Optional[LabelCounter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelCountersForWorkteam = {
    import LabelCountersForWorkteam.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelCountersForWorkteam
      .builder()
      .optionallyWith(
        humanLabeled.map(value => LabelCounter.unwrap(value): Integer)
      )(_.humanLabeled)
      .optionallyWith(
        pendingHuman.map(value => LabelCounter.unwrap(value): Integer)
      )(_.pendingHuman)
      .optionallyWith(total.map(value => LabelCounter.unwrap(value): Integer))(
        _.total
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelCountersForWorkteam.ReadOnly =
    zio.aws.sagemaker.model.LabelCountersForWorkteam.wrap(buildAwsValue())
}
object LabelCountersForWorkteam {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelCountersForWorkteam
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelCountersForWorkteam =
      zio.aws.sagemaker.model.LabelCountersForWorkteam(
        humanLabeled.map(value => value),
        pendingHuman.map(value => value),
        total.map(value => value)
      )
    def humanLabeled: Optional[LabelCounter]
    def pendingHuman: Optional[LabelCounter]
    def total: Optional[LabelCounter]
    def getHumanLabeled: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("humanLabeled", humanLabeled)
    def getPendingHuman: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("pendingHuman", pendingHuman)
    def getTotal: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("total", total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelCountersForWorkteam
  ) extends zio.aws.sagemaker.model.LabelCountersForWorkteam.ReadOnly {
    override val humanLabeled: Optional[LabelCounter] = zio.aws.core.internal
      .optionalFromNullable(impl.humanLabeled())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val pendingHuman: Optional[LabelCounter] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingHuman())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val total: Optional[LabelCounter] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelCountersForWorkteam
  ): zio.aws.sagemaker.model.LabelCountersForWorkteam.ReadOnly = new Wrapper(
    impl
  )
}
