package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeploymentConfig(
    blueGreenUpdatePolicy: Optional[
      zio.aws.sagemaker.model.BlueGreenUpdatePolicy
    ] = Optional.Absent,
    autoRollbackConfiguration: Optional[
      zio.aws.sagemaker.model.AutoRollbackConfig
    ] = Optional.Absent,
    rollingUpdatePolicy: Optional[zio.aws.sagemaker.model.RollingUpdatePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeploymentConfig = {
    import DeploymentConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeploymentConfig
      .builder()
      .optionallyWith(
        blueGreenUpdatePolicy.map(value => value.buildAwsValue())
      )(_.blueGreenUpdatePolicy)
      .optionallyWith(
        autoRollbackConfiguration.map(value => value.buildAwsValue())
      )(_.autoRollbackConfiguration)
      .optionallyWith(rollingUpdatePolicy.map(value => value.buildAwsValue()))(
        _.rollingUpdatePolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeploymentConfig.ReadOnly =
    zio.aws.sagemaker.model.DeploymentConfig.wrap(buildAwsValue())
}
object DeploymentConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeploymentConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeploymentConfig =
      zio.aws.sagemaker.model.DeploymentConfig(
        blueGreenUpdatePolicy.map(value => value.asEditable),
        autoRollbackConfiguration.map(value => value.asEditable),
        rollingUpdatePolicy.map(value => value.asEditable)
      )
    def blueGreenUpdatePolicy
        : Optional[zio.aws.sagemaker.model.BlueGreenUpdatePolicy.ReadOnly]
    def autoRollbackConfiguration
        : Optional[zio.aws.sagemaker.model.AutoRollbackConfig.ReadOnly]
    def rollingUpdatePolicy
        : Optional[zio.aws.sagemaker.model.RollingUpdatePolicy.ReadOnly]
    def getBlueGreenUpdatePolicy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.BlueGreenUpdatePolicy.ReadOnly
    ] =
      AwsError.unwrapOptionField("blueGreenUpdatePolicy", blueGreenUpdatePolicy)
    def getAutoRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoRollbackConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoRollbackConfiguration",
      autoRollbackConfiguration
    )
    def getRollingUpdatePolicy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RollingUpdatePolicy.ReadOnly
    ] = AwsError.unwrapOptionField("rollingUpdatePolicy", rollingUpdatePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentConfig
  ) extends zio.aws.sagemaker.model.DeploymentConfig.ReadOnly {
    override val blueGreenUpdatePolicy
        : Optional[zio.aws.sagemaker.model.BlueGreenUpdatePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blueGreenUpdatePolicy())
        .map(value => zio.aws.sagemaker.model.BlueGreenUpdatePolicy.wrap(value))
    override val autoRollbackConfiguration
        : Optional[zio.aws.sagemaker.model.AutoRollbackConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoRollbackConfiguration())
        .map(value => zio.aws.sagemaker.model.AutoRollbackConfig.wrap(value))
    override val rollingUpdatePolicy
        : Optional[zio.aws.sagemaker.model.RollingUpdatePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rollingUpdatePolicy())
        .map(value => zio.aws.sagemaker.model.RollingUpdatePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentConfig
  ): zio.aws.sagemaker.model.DeploymentConfig.ReadOnly = new Wrapper(impl)
}
