package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{SecurityGroupId, RoleArn}
import scala.jdk.CollectionConverters._
final case class DefaultSpaceSettings(
    executionRole: Optional[RoleArn] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    jupyterServerAppSettings: Optional[
      zio.aws.sagemaker.model.JupyterServerAppSettings
    ] = Optional.Absent,
    kernelGatewayAppSettings: Optional[
      zio.aws.sagemaker.model.KernelGatewayAppSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DefaultSpaceSettings = {
    import DefaultSpaceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DefaultSpaceSettings
      .builder()
      .optionallyWith(
        executionRole.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRole)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        jupyterServerAppSettings.map(value => value.buildAwsValue())
      )(_.jupyterServerAppSettings)
      .optionallyWith(
        kernelGatewayAppSettings.map(value => value.buildAwsValue())
      )(_.kernelGatewayAppSettings)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DefaultSpaceSettings.ReadOnly =
    zio.aws.sagemaker.model.DefaultSpaceSettings.wrap(buildAwsValue())
}
object DefaultSpaceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DefaultSpaceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DefaultSpaceSettings =
      zio.aws.sagemaker.model.DefaultSpaceSettings(
        executionRole.map(value => value),
        securityGroups.map(value => value),
        jupyterServerAppSettings.map(value => value.asEditable),
        kernelGatewayAppSettings.map(value => value.asEditable)
      )
    def executionRole: Optional[RoleArn]
    def securityGroups: Optional[List[SecurityGroupId]]
    def jupyterServerAppSettings
        : Optional[zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly]
    def kernelGatewayAppSettings
        : Optional[zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly]
    def getExecutionRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getJupyterServerAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jupyterServerAppSettings",
      jupyterServerAppSettings
    )
    def getKernelGatewayAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kernelGatewayAppSettings",
      kernelGatewayAppSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DefaultSpaceSettings
  ) extends zio.aws.sagemaker.model.DefaultSpaceSettings.ReadOnly {
    override val executionRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val jupyterServerAppSettings
        : Optional[zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jupyterServerAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.JupyterServerAppSettings.wrap(value)
        )
    override val kernelGatewayAppSettings
        : Optional[zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kernelGatewayAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.KernelGatewayAppSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DefaultSpaceSettings
  ): zio.aws.sagemaker.model.DefaultSpaceSettings.ReadOnly = new Wrapper(impl)
}
