package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.TrialArn
import scala.jdk.CollectionConverters._
final case class CreateTrialResponse(
    trialArn: Optional[TrialArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse = {
    import CreateTrialResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse
      .builder()
      .optionallyWith(
        trialArn.map(value => TrialArn.unwrap(value): java.lang.String)
      )(_.trialArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateTrialResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateTrialResponse.wrap(buildAwsValue())
}
object CreateTrialResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateTrialResponse =
      zio.aws.sagemaker.model.CreateTrialResponse(trialArn.map(value => value))
    def trialArn: Optional[TrialArn]
    def getTrialArn: ZIO[Any, AwsError, TrialArn] =
      AwsError.unwrapOptionField("trialArn", trialArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse
  ) extends zio.aws.sagemaker.model.CreateTrialResponse.ReadOnly {
    override val trialArn: Optional[TrialArn] = zio.aws.core.internal
      .optionalFromNullable(impl.trialArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse
  ): zio.aws.sagemaker.model.CreateTrialResponse.ReadOnly = new Wrapper(impl)
}
