package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  CustomerMetadataValue,
  S3Uri,
  CustomerMetadataKey,
  CertifyForMarketplace,
  ArnOrName,
  ClientToken,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class CreateModelPackageRequest(
    modelPackageName: Optional[EntityName] = Optional.Absent,
    modelPackageGroupName: Optional[ArnOrName] = Optional.Absent,
    modelPackageDescription: Optional[EntityDescription] = Optional.Absent,
    inferenceSpecification: Optional[
      zio.aws.sagemaker.model.InferenceSpecification
    ] = Optional.Absent,
    validationSpecification: Optional[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification
    ] = Optional.Absent,
    sourceAlgorithmSpecification: Optional[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification
    ] = Optional.Absent,
    certifyForMarketplace: Optional[CertifyForMarketplace] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    modelApprovalStatus: Optional[zio.aws.sagemaker.model.ModelApprovalStatus] =
      Optional.Absent,
    metadataProperties: Optional[zio.aws.sagemaker.model.MetadataProperties] =
      Optional.Absent,
    modelMetrics: Optional[zio.aws.sagemaker.model.ModelMetrics] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    customerMetadataProperties: Optional[
      Map[CustomerMetadataKey, CustomerMetadataValue]
    ] = Optional.Absent,
    driftCheckBaselines: Optional[zio.aws.sagemaker.model.DriftCheckBaselines] =
      Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    task: Optional[String] = Optional.Absent,
    samplePayloadUrl: Optional[S3Uri] = Optional.Absent,
    additionalInferenceSpecifications: Optional[Iterable[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
    ]] = Optional.Absent,
    skipModelValidation: Optional[zio.aws.sagemaker.model.SkipModelValidation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest = {
    import CreateModelPackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest
      .builder()
      .optionallyWith(
        modelPackageName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.modelPackageName)
      .optionallyWith(
        modelPackageGroupName.map(value =>
          ArnOrName.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(
        modelPackageDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageDescription)
      .optionallyWith(
        inferenceSpecification.map(value => value.buildAwsValue())
      )(_.inferenceSpecification)
      .optionallyWith(
        validationSpecification.map(value => value.buildAwsValue())
      )(_.validationSpecification)
      .optionallyWith(
        sourceAlgorithmSpecification.map(value => value.buildAwsValue())
      )(_.sourceAlgorithmSpecification)
      .optionallyWith(
        certifyForMarketplace.map(value =>
          CertifyForMarketplace.unwrap(value): java.lang.Boolean
        )
      )(_.certifyForMarketplace)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(modelApprovalStatus.map(value => value.unwrap))(
        _.modelApprovalStatus
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(modelMetrics.map(value => value.buildAwsValue()))(
        _.modelMetrics
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        customerMetadataProperties.map(value =>
          value
            .map({ case (key, value) =>
              (CustomerMetadataKey.unwrap(
                key
              ): java.lang.String) -> (CustomerMetadataValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.customerMetadataProperties)
      .optionallyWith(driftCheckBaselines.map(value => value.buildAwsValue()))(
        _.driftCheckBaselines
      )
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(task.map(value => value: java.lang.String))(_.task)
      .optionallyWith(
        samplePayloadUrl.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.samplePayloadUrl)
      .optionallyWith(
        additionalInferenceSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalInferenceSpecifications)
      .optionallyWith(skipModelValidation.map(value => value.unwrap))(
        _.skipModelValidation
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateModelPackageRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelPackageRequest.wrap(buildAwsValue())
}
object CreateModelPackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelPackageRequest =
      zio.aws.sagemaker.model.CreateModelPackageRequest(
        modelPackageName.map(value => value),
        modelPackageGroupName.map(value => value),
        modelPackageDescription.map(value => value),
        inferenceSpecification.map(value => value.asEditable),
        validationSpecification.map(value => value.asEditable),
        sourceAlgorithmSpecification.map(value => value.asEditable),
        certifyForMarketplace.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        modelApprovalStatus.map(value => value),
        metadataProperties.map(value => value.asEditable),
        modelMetrics.map(value => value.asEditable),
        clientToken.map(value => value),
        customerMetadataProperties.map(value => value),
        driftCheckBaselines.map(value => value.asEditable),
        domain.map(value => value),
        task.map(value => value),
        samplePayloadUrl.map(value => value),
        additionalInferenceSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        skipModelValidation.map(value => value)
      )
    def modelPackageName: Optional[EntityName]
    def modelPackageGroupName: Optional[ArnOrName]
    def modelPackageDescription: Optional[EntityDescription]
    def inferenceSpecification
        : Optional[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly]
    def validationSpecification: Optional[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ]
    def sourceAlgorithmSpecification: Optional[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ]
    def certifyForMarketplace: Optional[CertifyForMarketplace]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def modelApprovalStatus
        : Optional[zio.aws.sagemaker.model.ModelApprovalStatus]
    def metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def modelMetrics: Optional[zio.aws.sagemaker.model.ModelMetrics.ReadOnly]
    def clientToken: Optional[ClientToken]
    def customerMetadataProperties
        : Optional[Map[CustomerMetadataKey, CustomerMetadataValue]]
    def driftCheckBaselines
        : Optional[zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly]
    def domain: Optional[String]
    def task: Optional[String]
    def samplePayloadUrl: Optional[S3Uri]
    def additionalInferenceSpecifications: Optional[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]]
    def skipModelValidation
        : Optional[zio.aws.sagemaker.model.SkipModelValidation]
    def getModelPackageName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelPackageName", modelPackageName)
    def getModelPackageGroupName: ZIO[Any, AwsError, ArnOrName] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getModelPackageDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageDescription",
        modelPackageDescription
      )
    def getInferenceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceSpecification",
      inferenceSpecification
    )
    def getValidationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "validationSpecification",
      validationSpecification
    )
    def getSourceAlgorithmSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceAlgorithmSpecification",
      sourceAlgorithmSpecification
    )
    def getCertifyForMarketplace: ZIO[Any, AwsError, CertifyForMarketplace] =
      AwsError.unwrapOptionField("certifyForMarketplace", certifyForMarketplace)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getModelApprovalStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelApprovalStatus] =
      AwsError.unwrapOptionField("modelApprovalStatus", modelApprovalStatus)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getModelMetrics
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelMetrics.ReadOnly] =
      AwsError.unwrapOptionField("modelMetrics", modelMetrics)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCustomerMetadataProperties
        : ZIO[Any, AwsError, Map[CustomerMetadataKey, CustomerMetadataValue]] =
      AwsError.unwrapOptionField(
        "customerMetadataProperties",
        customerMetadataProperties
      )
    def getDriftCheckBaselines: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly
    ] = AwsError.unwrapOptionField("driftCheckBaselines", driftCheckBaselines)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getTask: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("task", task)
    def getSamplePayloadUrl: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("samplePayloadUrl", samplePayloadUrl)
    def getAdditionalInferenceSpecifications: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalInferenceSpecifications",
      additionalInferenceSpecifications
    )
    def getSkipModelValidation
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SkipModelValidation] =
      AwsError.unwrapOptionField("skipModelValidation", skipModelValidation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest
  ) extends zio.aws.sagemaker.model.CreateModelPackageRequest.ReadOnly {
    override val modelPackageName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelPackageName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelPackageGroupName: Optional[ArnOrName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageGroupName())
        .map(value => zio.aws.sagemaker.model.primitives.ArnOrName(value))
    override val modelPackageDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val inferenceSpecification
        : Optional[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSpecification())
        .map(value =>
          zio.aws.sagemaker.model.InferenceSpecification.wrap(value)
        )
    override val validationSpecification: Optional[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validationSpecification())
      .map(value =>
        zio.aws.sagemaker.model.ModelPackageValidationSpecification.wrap(value)
      )
    override val sourceAlgorithmSpecification: Optional[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAlgorithmSpecification())
      .map(value =>
        zio.aws.sagemaker.model.SourceAlgorithmSpecification.wrap(value)
      )
    override val certifyForMarketplace: Optional[CertifyForMarketplace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certifyForMarketplace())
        .map(value =>
          zio.aws.sagemaker.model.primitives.CertifyForMarketplace(value)
        )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val modelApprovalStatus
        : Optional[zio.aws.sagemaker.model.ModelApprovalStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelApprovalStatus())
        .map(value => zio.aws.sagemaker.model.ModelApprovalStatus.wrap(value))
    override val metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataProperties())
        .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val modelMetrics
        : Optional[zio.aws.sagemaker.model.ModelMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelMetrics())
        .map(value => zio.aws.sagemaker.model.ModelMetrics.wrap(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.sagemaker.model.primitives.ClientToken(value))
    override val customerMetadataProperties
        : Optional[Map[CustomerMetadataKey, CustomerMetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerMetadataProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives
                .CustomerMetadataKey(key) -> zio.aws.sagemaker.model.primitives
                .CustomerMetadataValue(value)
            })
            .toMap
        )
    override val driftCheckBaselines
        : Optional[zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driftCheckBaselines())
        .map(value => zio.aws.sagemaker.model.DriftCheckBaselines.wrap(value))
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val task: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.task())
      .map(value => value: String)
    override val samplePayloadUrl: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.samplePayloadUrl())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val additionalInferenceSpecifications: Optional[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInferenceSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
            .wrap(item)
        }.toList
      )
    override val skipModelValidation
        : Optional[zio.aws.sagemaker.model.SkipModelValidation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skipModelValidation())
        .map(value => zio.aws.sagemaker.model.SkipModelValidation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest
  ): zio.aws.sagemaker.model.CreateModelPackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
