package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  TrainingJobArn,
  TrainingJobName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TrainingJobSummary(
    trainingJobName: TrainingJobName,
    trainingJobArn: TrainingJobArn,
    creationTime: Timestamp,
    trainingEndTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    trainingJobStatus: zio.aws.sagemaker.model.TrainingJobStatus,
    warmPoolStatus: Optional[zio.aws.sagemaker.model.WarmPoolStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrainingJobSummary = {
    import TrainingJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrainingJobSummary
      .builder()
      .trainingJobName(
        TrainingJobName.unwrap(trainingJobName): java.lang.String
      )
      .trainingJobArn(TrainingJobArn.unwrap(trainingJobArn): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        trainingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingEndTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .trainingJobStatus(trainingJobStatus.unwrap)
      .optionallyWith(warmPoolStatus.map(value => value.buildAwsValue()))(
        _.warmPoolStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly =
    zio.aws.sagemaker.model.TrainingJobSummary.wrap(buildAwsValue())
}
object TrainingJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrainingJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrainingJobSummary =
      zio.aws.sagemaker.model.TrainingJobSummary(
        trainingJobName,
        trainingJobArn,
        creationTime,
        trainingEndTime.map(value => value),
        lastModifiedTime.map(value => value),
        trainingJobStatus,
        warmPoolStatus.map(value => value.asEditable)
      )
    def trainingJobName: TrainingJobName
    def trainingJobArn: TrainingJobArn
    def creationTime: Timestamp
    def trainingEndTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def trainingJobStatus: zio.aws.sagemaker.model.TrainingJobStatus
    def warmPoolStatus
        : Optional[zio.aws.sagemaker.model.WarmPoolStatus.ReadOnly]
    def getTrainingJobName: ZIO[Any, Nothing, TrainingJobName] =
      ZIO.succeed(trainingJobName)
    def getTrainingJobArn: ZIO[Any, Nothing, TrainingJobArn] =
      ZIO.succeed(trainingJobArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getTrainingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingEndTime", trainingEndTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getTrainingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingJobStatus] =
      ZIO.succeed(trainingJobStatus)
    def getWarmPoolStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.WarmPoolStatus.ReadOnly] =
      AwsError.unwrapOptionField("warmPoolStatus", warmPoolStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobSummary
  ) extends zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly {
    override val trainingJobName: TrainingJobName =
      zio.aws.sagemaker.model.primitives.TrainingJobName(impl.trainingJobName())
    override val trainingJobArn: TrainingJobArn =
      zio.aws.sagemaker.model.primitives.TrainingJobArn(impl.trainingJobArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val trainingEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val trainingJobStatus: zio.aws.sagemaker.model.TrainingJobStatus =
      zio.aws.sagemaker.model.TrainingJobStatus.wrap(impl.trainingJobStatus())
    override val warmPoolStatus
        : Optional[zio.aws.sagemaker.model.WarmPoolStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warmPoolStatus())
        .map(value => zio.aws.sagemaker.model.WarmPoolStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobSummary
  ): zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly = new Wrapper(impl)
}
