package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrainingImageConfig(
    trainingRepositoryAccessMode: zio.aws.sagemaker.model.TrainingRepositoryAccessMode,
    trainingRepositoryAuthConfig: Optional[
      zio.aws.sagemaker.model.TrainingRepositoryAuthConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrainingImageConfig = {
    import TrainingImageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrainingImageConfig
      .builder()
      .trainingRepositoryAccessMode(trainingRepositoryAccessMode.unwrap)
      .optionallyWith(
        trainingRepositoryAuthConfig.map(value => value.buildAwsValue())
      )(_.trainingRepositoryAuthConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrainingImageConfig.ReadOnly =
    zio.aws.sagemaker.model.TrainingImageConfig.wrap(buildAwsValue())
}
object TrainingImageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrainingImageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrainingImageConfig =
      zio.aws.sagemaker.model.TrainingImageConfig(
        trainingRepositoryAccessMode,
        trainingRepositoryAuthConfig.map(value => value.asEditable)
      )
    def trainingRepositoryAccessMode
        : zio.aws.sagemaker.model.TrainingRepositoryAccessMode
    def trainingRepositoryAuthConfig: Optional[
      zio.aws.sagemaker.model.TrainingRepositoryAuthConfig.ReadOnly
    ]
    def getTrainingRepositoryAccessMode: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TrainingRepositoryAccessMode
    ] = ZIO.succeed(trainingRepositoryAccessMode)
    def getTrainingRepositoryAuthConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrainingRepositoryAuthConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "trainingRepositoryAuthConfig",
      trainingRepositoryAuthConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingImageConfig
  ) extends zio.aws.sagemaker.model.TrainingImageConfig.ReadOnly {
    override val trainingRepositoryAccessMode
        : zio.aws.sagemaker.model.TrainingRepositoryAccessMode =
      zio.aws.sagemaker.model.TrainingRepositoryAccessMode
        .wrap(impl.trainingRepositoryAccessMode())
    override val trainingRepositoryAuthConfig: Optional[
      zio.aws.sagemaker.model.TrainingRepositoryAuthConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingRepositoryAuthConfig())
      .map(value =>
        zio.aws.sagemaker.model.TrainingRepositoryAuthConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingImageConfig
  ): zio.aws.sagemaker.model.TrainingImageConfig.ReadOnly = new Wrapper(impl)
}
