package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SuggestionQuery(
    propertyNameQuery: Optional[zio.aws.sagemaker.model.PropertyNameQuery] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SuggestionQuery = {
    import SuggestionQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SuggestionQuery
      .builder()
      .optionallyWith(propertyNameQuery.map(value => value.buildAwsValue()))(
        _.propertyNameQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SuggestionQuery.ReadOnly =
    zio.aws.sagemaker.model.SuggestionQuery.wrap(buildAwsValue())
}
object SuggestionQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SuggestionQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SuggestionQuery =
      zio.aws.sagemaker.model
        .SuggestionQuery(propertyNameQuery.map(value => value.asEditable))
    def propertyNameQuery
        : Optional[zio.aws.sagemaker.model.PropertyNameQuery.ReadOnly]
    def getPropertyNameQuery: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PropertyNameQuery.ReadOnly
    ] = AwsError.unwrapOptionField("propertyNameQuery", propertyNameQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SuggestionQuery
  ) extends zio.aws.sagemaker.model.SuggestionQuery.ReadOnly {
    override val propertyNameQuery
        : Optional[zio.aws.sagemaker.model.PropertyNameQuery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyNameQuery())
        .map(value => zio.aws.sagemaker.model.PropertyNameQuery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SuggestionQuery
  ): zio.aws.sagemaker.model.SuggestionQuery.ReadOnly = new Wrapper(impl)
}
