package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ModelCardVersionSortBy {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSortBy
}
object ModelCardVersionSortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSortBy
  ): zio.aws.sagemaker.model.ModelCardVersionSortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSortBy.VERSION =>
      val r = Version
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelCardVersionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSortBy =
      software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object Version extends zio.aws.sagemaker.model.ModelCardVersionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSortBy =
      software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSortBy.VERSION
  }
}
