package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  HyperParameterTuningJobName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTrainingJobsForHyperParameterTuningJobRequest(
    hyperParameterTuningJobName: HyperParameterTuningJobName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    statusEquals: Optional[zio.aws.sagemaker.model.TrainingJobStatus] =
      Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.TrainingJobSortByOptions] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest = {
    import ListTrainingJobsForHyperParameterTuningJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
      .builder()
      .hyperParameterTuningJobName(
        HyperParameterTuningJobName.unwrap(
          hyperParameterTuningJobName
        ): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest.ReadOnly =
    zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
      .wrap(buildAwsValue())
}
object ListTrainingJobsForHyperParameterTuningJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest =
      zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest(
        hyperParameterTuningJobName,
        nextToken.map(value => value),
        maxResults.map(value => value),
        statusEquals.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def hyperParameterTuningJobName: HyperParameterTuningJobName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def statusEquals: Optional[zio.aws.sagemaker.model.TrainingJobStatus]
    def sortBy: Optional[zio.aws.sagemaker.model.TrainingJobSortByOptions]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def getHyperParameterTuningJobName
        : ZIO[Any, Nothing, HyperParameterTuningJobName] =
      ZIO.succeed(hyperParameterTuningJobName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingJobSortByOptions] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
  ) extends zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest.ReadOnly {
    override val hyperParameterTuningJobName: HyperParameterTuningJobName =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobName(impl.hyperParameterTuningJobName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val statusEquals
        : Optional[zio.aws.sagemaker.model.TrainingJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.TrainingJobStatus.wrap(value))
    override val sortBy
        : Optional[zio.aws.sagemaker.model.TrainingJobSortByOptions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.TrainingJobSortByOptions.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
  ): zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest.ReadOnly =
    new Wrapper(impl)
}
