package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  SpaceName,
  DomainId,
  MaxResults,
  NextToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSpacesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.SpaceSortKey] = Optional.Absent,
    domainIdEquals: Optional[DomainId] = Optional.Absent,
    spaceNameContains: Optional[SpaceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListSpacesRequest = {
    import ListSpacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListSpacesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        domainIdEquals.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainIdEquals)
      .optionallyWith(
        spaceNameContains.map(value =>
          SpaceName.unwrap(value): java.lang.String
        )
      )(_.spaceNameContains)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListSpacesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListSpacesRequest.wrap(buildAwsValue())
}
object ListSpacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListSpacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListSpacesRequest =
      zio.aws.sagemaker.model.ListSpacesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        domainIdEquals.map(value => value),
        spaceNameContains.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def sortBy: Optional[zio.aws.sagemaker.model.SpaceSortKey]
    def domainIdEquals: Optional[DomainId]
    def spaceNameContains: Optional[SpaceName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.SpaceSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getDomainIdEquals: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainIdEquals", domainIdEquals)
    def getSpaceNameContains: ZIO[Any, AwsError, SpaceName] =
      AwsError.unwrapOptionField("spaceNameContains", spaceNameContains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListSpacesRequest
  ) extends zio.aws.sagemaker.model.ListSpacesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.SpaceSortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.SpaceSortKey.wrap(value))
    override val domainIdEquals: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIdEquals())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val spaceNameContains: Optional[SpaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceNameContains())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListSpacesRequest
  ): zio.aws.sagemaker.model.ListSpacesRequest.ReadOnly = new Wrapper(impl)
}
