package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  NameContains,
  LastModifiedTime,
  MaxResults,
  ModelPackageArn,
  ModelName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListInferenceRecommendationsJobsRequest(
    creationTimeAfter: Optional[CreationTime] = Optional.Absent,
    creationTimeBefore: Optional[CreationTime] = Optional.Absent,
    lastModifiedTimeAfter: Optional[LastModifiedTime] = Optional.Absent,
    lastModifiedTimeBefore: Optional[LastModifiedTime] = Optional.Absent,
    nameContains: Optional[NameContains] = Optional.Absent,
    statusEquals: Optional[zio.aws.sagemaker.model.RecommendationJobStatus] =
      Optional.Absent,
    sortBy: Optional[
      zio.aws.sagemaker.model.ListInferenceRecommendationsJobsSortBy
    ] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    modelNameEquals: Optional[ModelName] = Optional.Absent,
    modelPackageVersionArnEquals: Optional[ModelPackageArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest = {
    import ListInferenceRecommendationsJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        nameContains.map(value => NameContains.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        modelNameEquals.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelNameEquals)
      .optionallyWith(
        modelPackageVersionArnEquals.map(value =>
          ModelPackageArn.unwrap(value): java.lang.String
        )
      )(_.modelPackageVersionArnEquals)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListInferenceRecommendationsJobsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListInferenceRecommendationsJobsRequest
      .wrap(buildAwsValue())
}
object ListInferenceRecommendationsJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListInferenceRecommendationsJobsRequest =
      zio.aws.sagemaker.model.ListInferenceRecommendationsJobsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        nameContains.map(value => value),
        statusEquals.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        modelNameEquals.map(value => value),
        modelPackageVersionArnEquals.map(value => value)
      )
    def creationTimeAfter: Optional[CreationTime]
    def creationTimeBefore: Optional[CreationTime]
    def lastModifiedTimeAfter: Optional[LastModifiedTime]
    def lastModifiedTimeBefore: Optional[LastModifiedTime]
    def nameContains: Optional[NameContains]
    def statusEquals: Optional[zio.aws.sagemaker.model.RecommendationJobStatus]
    def sortBy: Optional[
      zio.aws.sagemaker.model.ListInferenceRecommendationsJobsSortBy
    ]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def modelNameEquals: Optional[ModelName]
    def modelPackageVersionArnEquals: Optional[ModelPackageArn]
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField(
        "lastModifiedTimeBefore",
        lastModifiedTimeBefore
      )
    def getNameContains: ZIO[Any, AwsError, NameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RecommendationJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ListInferenceRecommendationsJobsSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getModelNameEquals: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelNameEquals", modelNameEquals)
    def getModelPackageVersionArnEquals: ZIO[Any, AwsError, ModelPackageArn] =
      AwsError.unwrapOptionField(
        "modelPackageVersionArnEquals",
        modelPackageVersionArnEquals
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest
  ) extends zio.aws.sagemaker.model.ListInferenceRecommendationsJobsRequest.ReadOnly {
    override val creationTimeAfter: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeBefore: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTimeAfter: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeAfter())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val lastModifiedTimeBefore: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeBefore())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val nameContains: Optional[NameContains] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.NameContains(value))
    override val statusEquals
        : Optional[zio.aws.sagemaker.model.RecommendationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value =>
          zio.aws.sagemaker.model.RecommendationJobStatus.wrap(value)
        )
    override val sortBy: Optional[
      zio.aws.sagemaker.model.ListInferenceRecommendationsJobsSortBy
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.ListInferenceRecommendationsJobsSortBy
          .wrap(value)
      )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val modelNameEquals: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelNameEquals())
      .map(value => zio.aws.sagemaker.model.primitives.ModelName(value))
    override val modelPackageVersionArnEquals: Optional[ModelPackageArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageVersionArnEquals())
        .map(value => zio.aws.sagemaker.model.primitives.ModelPackageArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest
  ): zio.aws.sagemaker.model.ListInferenceRecommendationsJobsRequest.ReadOnly =
    new Wrapper(impl)
}
