package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait InputMode {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.InputMode
}
object InputMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.InputMode
  ): zio.aws.sagemaker.model.InputMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.InputMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.InputMode.PIPE =>
      val r = Pipe
      r
    case software.amazon.awssdk.services.sagemaker.model.InputMode.FILE =>
      val r = File
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.InputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InputMode =
      software.amazon.awssdk.services.sagemaker.model.InputMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Pipe extends zio.aws.sagemaker.model.InputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InputMode =
      software.amazon.awssdk.services.sagemaker.model.InputMode.PIPE
  }
  case object File extends zio.aws.sagemaker.model.InputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InputMode =
      software.amazon.awssdk.services.sagemaker.model.InputMode.FILE
  }
}
