package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ModelCardArn,
  Integer,
  EntityName,
  ModelCardContent
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeModelCardResponse(
    modelCardArn: ModelCardArn,
    modelCardName: EntityName,
    modelCardVersion: Integer,
    content: ModelCardContent,
    modelCardStatus: zio.aws.sagemaker.model.ModelCardStatus,
    securityConfig: Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig] =
      Optional.Absent,
    creationTime: Timestamp,
    createdBy: zio.aws.sagemaker.model.UserContext,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    modelCardProcessingStatus: Optional[
      zio.aws.sagemaker.model.ModelCardProcessingStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelCardResponse = {
    import DescribeModelCardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelCardResponse
      .builder()
      .modelCardArn(ModelCardArn.unwrap(modelCardArn): java.lang.String)
      .modelCardName(EntityName.unwrap(modelCardName): java.lang.String)
      .modelCardVersion(modelCardVersion: java.lang.Integer)
      .content(ModelCardContent.unwrap(content): java.lang.String)
      .modelCardStatus(modelCardStatus.unwrap)
      .optionallyWith(securityConfig.map(value => value.buildAwsValue()))(
        _.securityConfig
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .createdBy(createdBy.buildAwsValue())
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(modelCardProcessingStatus.map(value => value.unwrap))(
        _.modelCardProcessingStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeModelCardResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelCardResponse.wrap(buildAwsValue())
}
object DescribeModelCardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelCardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelCardResponse =
      zio.aws.sagemaker.model.DescribeModelCardResponse(
        modelCardArn,
        modelCardName,
        modelCardVersion,
        content,
        modelCardStatus,
        securityConfig.map(value => value.asEditable),
        creationTime,
        createdBy.asEditable,
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        modelCardProcessingStatus.map(value => value)
      )
    def modelCardArn: ModelCardArn
    def modelCardName: EntityName
    def modelCardVersion: Integer
    def content: ModelCardContent
    def modelCardStatus: zio.aws.sagemaker.model.ModelCardStatus
    def securityConfig
        : Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly]
    def creationTime: Timestamp
    def createdBy: zio.aws.sagemaker.model.UserContext.ReadOnly
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def modelCardProcessingStatus
        : Optional[zio.aws.sagemaker.model.ModelCardProcessingStatus]
    def getModelCardArn: ZIO[Any, Nothing, ModelCardArn] =
      ZIO.succeed(modelCardArn)
    def getModelCardName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardName)
    def getModelCardVersion: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(modelCardVersion)
    def getContent: ZIO[Any, Nothing, ModelCardContent] = ZIO.succeed(content)
    def getModelCardStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelCardStatus] =
      ZIO.succeed(modelCardStatus)
    def getSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfig", securityConfig)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getCreatedBy
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      ZIO.succeed(createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getModelCardProcessingStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelCardProcessingStatus
    ] = AwsError.unwrapOptionField(
      "modelCardProcessingStatus",
      modelCardProcessingStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelCardResponse
  ) extends zio.aws.sagemaker.model.DescribeModelCardResponse.ReadOnly {
    override val modelCardArn: ModelCardArn =
      zio.aws.sagemaker.model.primitives.ModelCardArn(impl.modelCardArn())
    override val modelCardName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelCardName())
    override val modelCardVersion: Integer = impl.modelCardVersion(): Integer
    override val content: ModelCardContent =
      zio.aws.sagemaker.model.primitives.ModelCardContent(impl.content())
    override val modelCardStatus: zio.aws.sagemaker.model.ModelCardStatus =
      zio.aws.sagemaker.model.ModelCardStatus.wrap(impl.modelCardStatus())
    override val securityConfig
        : Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityConfig())
        .map(value =>
          zio.aws.sagemaker.model.ModelCardSecurityConfig.wrap(value)
        )
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val createdBy: zio.aws.sagemaker.model.UserContext.ReadOnly =
      zio.aws.sagemaker.model.UserContext.wrap(impl.createdBy())
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val modelCardProcessingStatus
        : Optional[zio.aws.sagemaker.model.ModelCardProcessingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelCardProcessingStatus())
        .map(value =>
          zio.aws.sagemaker.model.ModelCardProcessingStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelCardResponse
  ): zio.aws.sagemaker.model.DescribeModelCardResponse.ReadOnly = new Wrapper(
    impl
  )
}
