package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  HubContentVersion,
  HubContentName,
  HubName
}
import scala.jdk.CollectionConverters._
final case class DeleteHubContentRequest(
    hubName: HubName,
    hubContentType: zio.aws.sagemaker.model.HubContentType,
    hubContentName: HubContentName,
    hubContentVersion: HubContentVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest = {
    import DeleteHubContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest
      .builder()
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .hubContentType(hubContentType.unwrap)
      .hubContentName(HubContentName.unwrap(hubContentName): java.lang.String)
      .hubContentVersion(
        HubContentVersion.unwrap(hubContentVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteHubContentRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteHubContentRequest.wrap(buildAwsValue())
}
object DeleteHubContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteHubContentRequest =
      zio.aws.sagemaker.model.DeleteHubContentRequest(
        hubName,
        hubContentType,
        hubContentName,
        hubContentVersion
      )
    def hubName: HubName
    def hubContentType: zio.aws.sagemaker.model.HubContentType
    def hubContentName: HubContentName
    def hubContentVersion: HubContentVersion
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
    def getHubContentType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HubContentType] =
      ZIO.succeed(hubContentType)
    def getHubContentName: ZIO[Any, Nothing, HubContentName] =
      ZIO.succeed(hubContentName)
    def getHubContentVersion: ZIO[Any, Nothing, HubContentVersion] =
      ZIO.succeed(hubContentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest
  ) extends zio.aws.sagemaker.model.DeleteHubContentRequest.ReadOnly {
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
    override val hubContentType: zio.aws.sagemaker.model.HubContentType =
      zio.aws.sagemaker.model.HubContentType.wrap(impl.hubContentType())
    override val hubContentName: HubContentName =
      zio.aws.sagemaker.model.primitives.HubContentName(impl.hubContentName())
    override val hubContentVersion: HubContentVersion =
      zio.aws.sagemaker.model.primitives
        .HubContentVersion(impl.hubContentVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest
  ): zio.aws.sagemaker.model.DeleteHubContentRequest.ReadOnly = new Wrapper(
    impl
  )
}
