package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters._
final case class DeleteContextRequest(contextName: ExperimentEntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest = {
    import DeleteContextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest
      .builder()
      .contextName(ExperimentEntityName.unwrap(contextName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteContextRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteContextRequest.wrap(buildAwsValue())
}
object DeleteContextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteContextRequest =
      zio.aws.sagemaker.model.DeleteContextRequest(contextName)
    def contextName: ExperimentEntityName
    def getContextName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(contextName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest
  ) extends zio.aws.sagemaker.model.DeleteContextRequest.ReadOnly {
    override val contextName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.contextName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest
  ): zio.aws.sagemaker.model.DeleteContextRequest.ReadOnly = new Wrapper(impl)
}
