package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ContentType
import scala.jdk.CollectionConverters._
final case class AutoMLJobChannel(
    channelType: Optional[zio.aws.sagemaker.model.AutoMLChannelType] =
      Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    compressionType: Optional[zio.aws.sagemaker.model.CompressionType] =
      Optional.Absent,
    dataSource: Optional[zio.aws.sagemaker.model.AutoMLDataSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel = {
    import AutoMLJobChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel
      .builder()
      .optionallyWith(channelType.map(value => value.unwrap))(_.channelType)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLJobChannel.ReadOnly =
    zio.aws.sagemaker.model.AutoMLJobChannel.wrap(buildAwsValue())
}
object AutoMLJobChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLJobChannel =
      zio.aws.sagemaker.model.AutoMLJobChannel(
        channelType.map(value => value),
        contentType.map(value => value),
        compressionType.map(value => value),
        dataSource.map(value => value.asEditable)
      )
    def channelType: Optional[zio.aws.sagemaker.model.AutoMLChannelType]
    def contentType: Optional[ContentType]
    def compressionType: Optional[zio.aws.sagemaker.model.CompressionType]
    def dataSource: Optional[zio.aws.sagemaker.model.AutoMLDataSource.ReadOnly]
    def getChannelType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLChannelType] =
      AwsError.unwrapOptionField("channelType", channelType)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getCompressionType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CompressionType] =
      AwsError.unwrapOptionField("compressionType", compressionType)
    def getDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLDataSource.ReadOnly
    ] = AwsError.unwrapOptionField("dataSource", dataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel
  ) extends zio.aws.sagemaker.model.AutoMLJobChannel.ReadOnly {
    override val channelType
        : Optional[zio.aws.sagemaker.model.AutoMLChannelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelType())
        .map(value => zio.aws.sagemaker.model.AutoMLChannelType.wrap(value))
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.sagemaker.model.primitives.ContentType(value))
    override val compressionType
        : Optional[zio.aws.sagemaker.model.CompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compressionType())
        .map(value => zio.aws.sagemaker.model.CompressionType.wrap(value))
    override val dataSource
        : Optional[zio.aws.sagemaker.model.AutoMLDataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.sagemaker.model.AutoMLDataSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel
  ): zio.aws.sagemaker.model.AutoMLJobChannel.ReadOnly = new Wrapper(impl)
}
