package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{DestinationS3Uri, KmsKeyId}
import scala.jdk.CollectionConverters._
final case class AsyncInferenceOutputConfig(
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    s3OutputPath: Optional[DestinationS3Uri] = Optional.Absent,
    notificationConfig: Optional[
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig
    ] = Optional.Absent,
    s3FailurePath: Optional[DestinationS3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig = {
    import AsyncInferenceOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        s3OutputPath.map(value =>
          DestinationS3Uri.unwrap(value): java.lang.String
        )
      )(_.s3OutputPath)
      .optionallyWith(notificationConfig.map(value => value.buildAwsValue()))(
        _.notificationConfig
      )
      .optionallyWith(
        s3FailurePath.map(value =>
          DestinationS3Uri.unwrap(value): java.lang.String
        )
      )(_.s3FailurePath)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AsyncInferenceOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.AsyncInferenceOutputConfig.wrap(buildAwsValue())
}
object AsyncInferenceOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AsyncInferenceOutputConfig =
      zio.aws.sagemaker.model.AsyncInferenceOutputConfig(
        kmsKeyId.map(value => value),
        s3OutputPath.map(value => value),
        notificationConfig.map(value => value.asEditable),
        s3FailurePath.map(value => value)
      )
    def kmsKeyId: Optional[KmsKeyId]
    def s3OutputPath: Optional[DestinationS3Uri]
    def notificationConfig: Optional[
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly
    ]
    def s3FailurePath: Optional[DestinationS3Uri]
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getS3OutputPath: ZIO[Any, AwsError, DestinationS3Uri] =
      AwsError.unwrapOptionField("s3OutputPath", s3OutputPath)
    def getNotificationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("notificationConfig", notificationConfig)
    def getS3FailurePath: ZIO[Any, AwsError, DestinationS3Uri] =
      AwsError.unwrapOptionField("s3FailurePath", s3FailurePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig
  ) extends zio.aws.sagemaker.model.AsyncInferenceOutputConfig.ReadOnly {
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val s3OutputPath: Optional[DestinationS3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3OutputPath())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DestinationS3Uri(value)
        )
    override val notificationConfig: Optional[
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationConfig())
      .map(value =>
        zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.wrap(value)
      )
    override val s3FailurePath: Optional[DestinationS3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3FailurePath())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DestinationS3Uri(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig
  ): zio.aws.sagemaker.model.AsyncInferenceOutputConfig.ReadOnly = new Wrapper(
    impl
  )
}
