package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  MonitoringAlertName,
  MonitoringScheduleArn
}
import scala.jdk.CollectionConverters._
final case class UpdateMonitoringAlertResponse(
    monitoringScheduleArn: MonitoringScheduleArn,
    monitoringAlertName: Optional[MonitoringAlertName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertResponse = {
    import UpdateMonitoringAlertResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertResponse
      .builder()
      .monitoringScheduleArn(
        MonitoringScheduleArn.unwrap(monitoringScheduleArn): java.lang.String
      )
      .optionallyWith(
        monitoringAlertName.map(value =>
          MonitoringAlertName.unwrap(value): java.lang.String
        )
      )(_.monitoringAlertName)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateMonitoringAlertResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateMonitoringAlertResponse.wrap(buildAwsValue())
}
object UpdateMonitoringAlertResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateMonitoringAlertResponse =
      zio.aws.sagemaker.model.UpdateMonitoringAlertResponse(
        monitoringScheduleArn,
        monitoringAlertName.map(value => value)
      )
    def monitoringScheduleArn: MonitoringScheduleArn
    def monitoringAlertName: Optional[MonitoringAlertName]
    def getMonitoringScheduleArn: ZIO[Any, Nothing, MonitoringScheduleArn] =
      ZIO.succeed(monitoringScheduleArn)
    def getMonitoringAlertName: ZIO[Any, AwsError, MonitoringAlertName] =
      AwsError.unwrapOptionField("monitoringAlertName", monitoringAlertName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertResponse
  ) extends zio.aws.sagemaker.model.UpdateMonitoringAlertResponse.ReadOnly {
    override val monitoringScheduleArn: MonitoringScheduleArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleArn(impl.monitoringScheduleArn())
    override val monitoringAlertName: Optional[MonitoringAlertName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringAlertName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MonitoringAlertName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertResponse
  ): zio.aws.sagemaker.model.UpdateMonitoringAlertResponse.ReadOnly =
    new Wrapper(impl)
}
