package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxWaitTimeInSeconds,
  MaxRuntimeInSeconds
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StoppingCondition(
    maxRuntimeInSeconds: Optional[MaxRuntimeInSeconds] = Optional.Absent,
    maxWaitTimeInSeconds: Optional[MaxWaitTimeInSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StoppingCondition = {
    import StoppingCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StoppingCondition
      .builder()
      .optionallyWith(
        maxRuntimeInSeconds.map(value =>
          MaxRuntimeInSeconds.unwrap(value): Integer
        )
      )(_.maxRuntimeInSeconds)
      .optionallyWith(
        maxWaitTimeInSeconds.map(value =>
          MaxWaitTimeInSeconds.unwrap(value): Integer
        )
      )(_.maxWaitTimeInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.StoppingCondition.ReadOnly =
    zio.aws.sagemaker.model.StoppingCondition.wrap(buildAwsValue())
}
object StoppingCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StoppingCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StoppingCondition =
      zio.aws.sagemaker.model.StoppingCondition(
        maxRuntimeInSeconds.map(value => value),
        maxWaitTimeInSeconds.map(value => value)
      )
    def maxRuntimeInSeconds: Optional[MaxRuntimeInSeconds]
    def maxWaitTimeInSeconds: Optional[MaxWaitTimeInSeconds]
    def getMaxRuntimeInSeconds: ZIO[Any, AwsError, MaxRuntimeInSeconds] =
      AwsError.unwrapOptionField("maxRuntimeInSeconds", maxRuntimeInSeconds)
    def getMaxWaitTimeInSeconds: ZIO[Any, AwsError, MaxWaitTimeInSeconds] =
      AwsError.unwrapOptionField("maxWaitTimeInSeconds", maxWaitTimeInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StoppingCondition
  ) extends zio.aws.sagemaker.model.StoppingCondition.ReadOnly {
    override val maxRuntimeInSeconds: Optional[MaxRuntimeInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRuntimeInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MaxRuntimeInSeconds(value)
        )
    override val maxWaitTimeInSeconds: Optional[MaxWaitTimeInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxWaitTimeInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MaxWaitTimeInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StoppingCondition
  ): zio.aws.sagemaker.model.StoppingCondition.ReadOnly = new Wrapper(impl)
}
