package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ProductionVariantInstanceType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType
}
object ProductionVariantInstanceType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType
  ): zio.aws.sagemaker.model.ProductionVariantInstanceType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_T2_MEDIUM =>
      val r = `ml.t2.medium`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_T2_LARGE =>
      val r = `ml.t2.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_T2_XLARGE =>
      val r = `ml.t2.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_T2_2_XLARGE =>
      val r = `ml.t2.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_XLARGE =>
      val r = `ml.m4.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_2_XLARGE =>
      val r = `ml.m4.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_4_XLARGE =>
      val r = `ml.m4.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_10_XLARGE =>
      val r = `ml.m4.10xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_16_XLARGE =>
      val r = `ml.m4.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_LARGE =>
      val r = `ml.m5.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_XLARGE =>
      val r = `ml.m5.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_2_XLARGE =>
      val r = `ml.m5.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_4_XLARGE =>
      val r = `ml.m5.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_12_XLARGE =>
      val r = `ml.m5.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_24_XLARGE =>
      val r = `ml.m5.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_LARGE =>
      val r = `ml.m5d.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_XLARGE =>
      val r = `ml.m5d.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_2_XLARGE =>
      val r = `ml.m5d.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_4_XLARGE =>
      val r = `ml.m5d.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_12_XLARGE =>
      val r = `ml.m5d.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_24_XLARGE =>
      val r = `ml.m5d.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_LARGE =>
      val r = `ml.c4.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_XLARGE =>
      val r = `ml.c4.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_2_XLARGE =>
      val r = `ml.c4.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_4_XLARGE =>
      val r = `ml.c4.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_8_XLARGE =>
      val r = `ml.c4.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P2_XLARGE =>
      val r = `ml.p2.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P2_8_XLARGE =>
      val r = `ml.p2.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P2_16_XLARGE =>
      val r = `ml.p2.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P3_2_XLARGE =>
      val r = `ml.p3.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P3_8_XLARGE =>
      val r = `ml.p3.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P3_16_XLARGE =>
      val r = `ml.p3.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_LARGE =>
      val r = `ml.c5.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_XLARGE =>
      val r = `ml.c5.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_2_XLARGE =>
      val r = `ml.c5.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_4_XLARGE =>
      val r = `ml.c5.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_9_XLARGE =>
      val r = `ml.c5.9xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_18_XLARGE =>
      val r = `ml.c5.18xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_LARGE =>
      val r = `ml.c5d.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_XLARGE =>
      val r = `ml.c5d.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_2_XLARGE =>
      val r = `ml.c5d.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_4_XLARGE =>
      val r = `ml.c5d.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_9_XLARGE =>
      val r = `ml.c5d.9xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_18_XLARGE =>
      val r = `ml.c5d.18xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_XLARGE =>
      val r = `ml.g4dn.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_2_XLARGE =>
      val r = `ml.g4dn.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_4_XLARGE =>
      val r = `ml.g4dn.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_8_XLARGE =>
      val r = `ml.g4dn.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_12_XLARGE =>
      val r = `ml.g4dn.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_16_XLARGE =>
      val r = `ml.g4dn.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_LARGE =>
      val r = `ml.r5.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_XLARGE =>
      val r = `ml.r5.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_2_XLARGE =>
      val r = `ml.r5.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_4_XLARGE =>
      val r = `ml.r5.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_12_XLARGE =>
      val r = `ml.r5.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_24_XLARGE =>
      val r = `ml.r5.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_LARGE =>
      val r = `ml.r5d.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_XLARGE =>
      val r = `ml.r5d.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_2_XLARGE =>
      val r = `ml.r5d.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_4_XLARGE =>
      val r = `ml.r5d.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_12_XLARGE =>
      val r = `ml.r5d.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_24_XLARGE =>
      val r = `ml.r5d.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF1_XLARGE =>
      val r = `ml.inf1.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF1_2_XLARGE =>
      val r = `ml.inf1.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF1_6_XLARGE =>
      val r = `ml.inf1.6xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF1_24_XLARGE =>
      val r = `ml.inf1.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_LARGE =>
      val r = `ml.c6i.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_XLARGE =>
      val r = `ml.c6i.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_2_XLARGE =>
      val r = `ml.c6i.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_4_XLARGE =>
      val r = `ml.c6i.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_8_XLARGE =>
      val r = `ml.c6i.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_12_XLARGE =>
      val r = `ml.c6i.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_16_XLARGE =>
      val r = `ml.c6i.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_24_XLARGE =>
      val r = `ml.c6i.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_32_XLARGE =>
      val r = `ml.c6i.32xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_XLARGE =>
      val r = `ml.g5.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_2_XLARGE =>
      val r = `ml.g5.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_4_XLARGE =>
      val r = `ml.g5.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_8_XLARGE =>
      val r = `ml.g5.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_12_XLARGE =>
      val r = `ml.g5.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_16_XLARGE =>
      val r = `ml.g5.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_24_XLARGE =>
      val r = `ml.g5.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_48_XLARGE =>
      val r = `ml.g5.48xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P4_D_24_XLARGE =>
      val r = `ml.p4d.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_LARGE =>
      val r = `ml.c7g.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_XLARGE =>
      val r = `ml.c7g.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_2_XLARGE =>
      val r = `ml.c7g.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_4_XLARGE =>
      val r = `ml.c7g.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_8_XLARGE =>
      val r = `ml.c7g.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_12_XLARGE =>
      val r = `ml.c7g.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_16_XLARGE =>
      val r = `ml.c7g.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_LARGE =>
      val r = `ml.m6g.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_XLARGE =>
      val r = `ml.m6g.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_2_XLARGE =>
      val r = `ml.m6g.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_4_XLARGE =>
      val r = `ml.m6g.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_8_XLARGE =>
      val r = `ml.m6g.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_12_XLARGE =>
      val r = `ml.m6g.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_16_XLARGE =>
      val r = `ml.m6g.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_LARGE =>
      val r = `ml.m6gd.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_XLARGE =>
      val r = `ml.m6gd.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_2_XLARGE =>
      val r = `ml.m6gd.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_4_XLARGE =>
      val r = `ml.m6gd.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_8_XLARGE =>
      val r = `ml.m6gd.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_12_XLARGE =>
      val r = `ml.m6gd.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_16_XLARGE =>
      val r = `ml.m6gd.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_LARGE =>
      val r = `ml.c6g.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_XLARGE =>
      val r = `ml.c6g.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_2_XLARGE =>
      val r = `ml.c6g.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_4_XLARGE =>
      val r = `ml.c6g.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_8_XLARGE =>
      val r = `ml.c6g.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_12_XLARGE =>
      val r = `ml.c6g.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_16_XLARGE =>
      val r = `ml.c6g.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_LARGE =>
      val r = `ml.c6gd.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_XLARGE =>
      val r = `ml.c6gd.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_2_XLARGE =>
      val r = `ml.c6gd.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_4_XLARGE =>
      val r = `ml.c6gd.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_8_XLARGE =>
      val r = `ml.c6gd.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_12_XLARGE =>
      val r = `ml.c6gd.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_16_XLARGE =>
      val r = `ml.c6gd.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_LARGE =>
      val r = `ml.c6gn.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_XLARGE =>
      val r = `ml.c6gn.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_2_XLARGE =>
      val r = `ml.c6gn.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_4_XLARGE =>
      val r = `ml.c6gn.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_8_XLARGE =>
      val r = `ml.c6gn.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_12_XLARGE =>
      val r = `ml.c6gn.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_16_XLARGE =>
      val r = `ml.c6gn.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_LARGE =>
      val r = `ml.r6g.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_XLARGE =>
      val r = `ml.r6g.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_2_XLARGE =>
      val r = `ml.r6g.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_4_XLARGE =>
      val r = `ml.r6g.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_8_XLARGE =>
      val r = `ml.r6g.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_12_XLARGE =>
      val r = `ml.r6g.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_16_XLARGE =>
      val r = `ml.r6g.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_LARGE =>
      val r = `ml.r6gd.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_XLARGE =>
      val r = `ml.r6gd.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_2_XLARGE =>
      val r = `ml.r6gd.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_4_XLARGE =>
      val r = `ml.r6gd.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_8_XLARGE =>
      val r = `ml.r6gd.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_12_XLARGE =>
      val r = `ml.r6gd.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_16_XLARGE =>
      val r = `ml.r6gd.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P4_DE_24_XLARGE =>
      val r = `ml.p4de.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_TRN1_2_XLARGE =>
      val r = `ml.trn1.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_TRN1_32_XLARGE =>
      val r = `ml.trn1.32xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF2_XLARGE =>
      val r = `ml.inf2.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF2_8_XLARGE =>
      val r = `ml.inf2.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF2_24_XLARGE =>
      val r = `ml.inf2.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF2_48_XLARGE =>
      val r = `ml.inf2.48xlarge`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `ml.t2.medium`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_T2_MEDIUM
  }
  case object `ml.t2.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_T2_LARGE
  }
  case object `ml.t2.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_T2_XLARGE
  }
  case object `ml.t2.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_T2_2_XLARGE
  }
  case object `ml.m4.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_XLARGE
  }
  case object `ml.m4.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_2_XLARGE
  }
  case object `ml.m4.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_4_XLARGE
  }
  case object `ml.m4.10xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_10_XLARGE
  }
  case object `ml.m4.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M4_16_XLARGE
  }
  case object `ml.m5.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_LARGE
  }
  case object `ml.m5.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_XLARGE
  }
  case object `ml.m5.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_2_XLARGE
  }
  case object `ml.m5.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_4_XLARGE
  }
  case object `ml.m5.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_12_XLARGE
  }
  case object `ml.m5.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_24_XLARGE
  }
  case object `ml.m5d.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_LARGE
  }
  case object `ml.m5d.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_XLARGE
  }
  case object `ml.m5d.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_2_XLARGE
  }
  case object `ml.m5d.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_4_XLARGE
  }
  case object `ml.m5d.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_12_XLARGE
  }
  case object `ml.m5d.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M5_D_24_XLARGE
  }
  case object `ml.c4.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_LARGE
  }
  case object `ml.c4.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_XLARGE
  }
  case object `ml.c4.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_2_XLARGE
  }
  case object `ml.c4.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_4_XLARGE
  }
  case object `ml.c4.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C4_8_XLARGE
  }
  case object `ml.p2.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P2_XLARGE
  }
  case object `ml.p2.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P2_8_XLARGE
  }
  case object `ml.p2.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P2_16_XLARGE
  }
  case object `ml.p3.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P3_2_XLARGE
  }
  case object `ml.p3.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P3_8_XLARGE
  }
  case object `ml.p3.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P3_16_XLARGE
  }
  case object `ml.c5.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_LARGE
  }
  case object `ml.c5.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_XLARGE
  }
  case object `ml.c5.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_2_XLARGE
  }
  case object `ml.c5.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_4_XLARGE
  }
  case object `ml.c5.9xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_9_XLARGE
  }
  case object `ml.c5.18xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_18_XLARGE
  }
  case object `ml.c5d.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_LARGE
  }
  case object `ml.c5d.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_XLARGE
  }
  case object `ml.c5d.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_2_XLARGE
  }
  case object `ml.c5d.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_4_XLARGE
  }
  case object `ml.c5d.9xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_9_XLARGE
  }
  case object `ml.c5d.18xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C5_D_18_XLARGE
  }
  case object `ml.g4dn.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_XLARGE
  }
  case object `ml.g4dn.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_2_XLARGE
  }
  case object `ml.g4dn.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_4_XLARGE
  }
  case object `ml.g4dn.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_8_XLARGE
  }
  case object `ml.g4dn.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_12_XLARGE
  }
  case object `ml.g4dn.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G4_DN_16_XLARGE
  }
  case object `ml.r5.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_LARGE
  }
  case object `ml.r5.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_XLARGE
  }
  case object `ml.r5.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_2_XLARGE
  }
  case object `ml.r5.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_4_XLARGE
  }
  case object `ml.r5.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_12_XLARGE
  }
  case object `ml.r5.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_24_XLARGE
  }
  case object `ml.r5d.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_LARGE
  }
  case object `ml.r5d.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_XLARGE
  }
  case object `ml.r5d.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_2_XLARGE
  }
  case object `ml.r5d.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_4_XLARGE
  }
  case object `ml.r5d.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_12_XLARGE
  }
  case object `ml.r5d.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R5_D_24_XLARGE
  }
  case object `ml.inf1.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF1_XLARGE
  }
  case object `ml.inf1.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF1_2_XLARGE
  }
  case object `ml.inf1.6xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF1_6_XLARGE
  }
  case object `ml.inf1.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF1_24_XLARGE
  }
  case object `ml.c6i.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_LARGE
  }
  case object `ml.c6i.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_XLARGE
  }
  case object `ml.c6i.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_2_XLARGE
  }
  case object `ml.c6i.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_4_XLARGE
  }
  case object `ml.c6i.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_8_XLARGE
  }
  case object `ml.c6i.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_12_XLARGE
  }
  case object `ml.c6i.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_16_XLARGE
  }
  case object `ml.c6i.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_24_XLARGE
  }
  case object `ml.c6i.32xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_I_32_XLARGE
  }
  case object `ml.g5.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_XLARGE
  }
  case object `ml.g5.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_2_XLARGE
  }
  case object `ml.g5.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_4_XLARGE
  }
  case object `ml.g5.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_8_XLARGE
  }
  case object `ml.g5.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_12_XLARGE
  }
  case object `ml.g5.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_16_XLARGE
  }
  case object `ml.g5.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_24_XLARGE
  }
  case object `ml.g5.48xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_G5_48_XLARGE
  }
  case object `ml.p4d.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P4_D_24_XLARGE
  }
  case object `ml.c7g.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_LARGE
  }
  case object `ml.c7g.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_XLARGE
  }
  case object `ml.c7g.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_2_XLARGE
  }
  case object `ml.c7g.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_4_XLARGE
  }
  case object `ml.c7g.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_8_XLARGE
  }
  case object `ml.c7g.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_12_XLARGE
  }
  case object `ml.c7g.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C7_G_16_XLARGE
  }
  case object `ml.m6g.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_LARGE
  }
  case object `ml.m6g.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_XLARGE
  }
  case object `ml.m6g.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_2_XLARGE
  }
  case object `ml.m6g.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_4_XLARGE
  }
  case object `ml.m6g.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_8_XLARGE
  }
  case object `ml.m6g.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_12_XLARGE
  }
  case object `ml.m6g.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_G_16_XLARGE
  }
  case object `ml.m6gd.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_LARGE
  }
  case object `ml.m6gd.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_XLARGE
  }
  case object `ml.m6gd.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_2_XLARGE
  }
  case object `ml.m6gd.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_4_XLARGE
  }
  case object `ml.m6gd.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_8_XLARGE
  }
  case object `ml.m6gd.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_12_XLARGE
  }
  case object `ml.m6gd.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_M6_GD_16_XLARGE
  }
  case object `ml.c6g.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_LARGE
  }
  case object `ml.c6g.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_XLARGE
  }
  case object `ml.c6g.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_2_XLARGE
  }
  case object `ml.c6g.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_4_XLARGE
  }
  case object `ml.c6g.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_8_XLARGE
  }
  case object `ml.c6g.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_12_XLARGE
  }
  case object `ml.c6g.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_G_16_XLARGE
  }
  case object `ml.c6gd.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_LARGE
  }
  case object `ml.c6gd.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_XLARGE
  }
  case object `ml.c6gd.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_2_XLARGE
  }
  case object `ml.c6gd.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_4_XLARGE
  }
  case object `ml.c6gd.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_8_XLARGE
  }
  case object `ml.c6gd.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_12_XLARGE
  }
  case object `ml.c6gd.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GD_16_XLARGE
  }
  case object `ml.c6gn.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_LARGE
  }
  case object `ml.c6gn.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_XLARGE
  }
  case object `ml.c6gn.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_2_XLARGE
  }
  case object `ml.c6gn.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_4_XLARGE
  }
  case object `ml.c6gn.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_8_XLARGE
  }
  case object `ml.c6gn.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_12_XLARGE
  }
  case object `ml.c6gn.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_C6_GN_16_XLARGE
  }
  case object `ml.r6g.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_LARGE
  }
  case object `ml.r6g.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_XLARGE
  }
  case object `ml.r6g.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_2_XLARGE
  }
  case object `ml.r6g.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_4_XLARGE
  }
  case object `ml.r6g.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_8_XLARGE
  }
  case object `ml.r6g.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_12_XLARGE
  }
  case object `ml.r6g.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_G_16_XLARGE
  }
  case object `ml.r6gd.large`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_LARGE
  }
  case object `ml.r6gd.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_XLARGE
  }
  case object `ml.r6gd.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_2_XLARGE
  }
  case object `ml.r6gd.4xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_4_XLARGE
  }
  case object `ml.r6gd.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_8_XLARGE
  }
  case object `ml.r6gd.12xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_12_XLARGE
  }
  case object `ml.r6gd.16xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_R6_GD_16_XLARGE
  }
  case object `ml.p4de.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_P4_DE_24_XLARGE
  }
  case object `ml.trn1.2xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_TRN1_2_XLARGE
  }
  case object `ml.trn1.32xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_TRN1_32_XLARGE
  }
  case object `ml.inf2.xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF2_XLARGE
  }
  case object `ml.inf2.8xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF2_8_XLARGE
  }
  case object `ml.inf2.24xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF2_24_XLARGE
  }
  case object `ml.inf2.48xlarge`
      extends zio.aws.sagemaker.model.ProductionVariantInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType =
      software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType.ML_INF2_48_XLARGE
  }
}
