package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModelInfrastructureConfig(
    infrastructureType: zio.aws.sagemaker.model.ModelInfrastructureType,
    realTimeInferenceConfig: zio.aws.sagemaker.model.RealTimeInferenceConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureConfig = {
    import ModelInfrastructureConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureConfig
      .builder()
      .infrastructureType(infrastructureType.unwrap)
      .realTimeInferenceConfig(realTimeInferenceConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelInfrastructureConfig.ReadOnly =
    zio.aws.sagemaker.model.ModelInfrastructureConfig.wrap(buildAwsValue())
}
object ModelInfrastructureConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelInfrastructureConfig =
      zio.aws.sagemaker.model.ModelInfrastructureConfig(
        infrastructureType,
        realTimeInferenceConfig.asEditable
      )
    def infrastructureType: zio.aws.sagemaker.model.ModelInfrastructureType
    def realTimeInferenceConfig
        : zio.aws.sagemaker.model.RealTimeInferenceConfig.ReadOnly
    def getInfrastructureType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelInfrastructureType] =
      ZIO.succeed(infrastructureType)
    def getRealTimeInferenceConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.RealTimeInferenceConfig.ReadOnly
    ] = ZIO.succeed(realTimeInferenceConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureConfig
  ) extends zio.aws.sagemaker.model.ModelInfrastructureConfig.ReadOnly {
    override val infrastructureType
        : zio.aws.sagemaker.model.ModelInfrastructureType =
      zio.aws.sagemaker.model.ModelInfrastructureType
        .wrap(impl.infrastructureType())
    override val realTimeInferenceConfig
        : zio.aws.sagemaker.model.RealTimeInferenceConfig.ReadOnly =
      zio.aws.sagemaker.model.RealTimeInferenceConfig
        .wrap(impl.realTimeInferenceConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureConfig
  ): zio.aws.sagemaker.model.ModelInfrastructureConfig.ReadOnly = new Wrapper(
    impl
  )
}
