package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListStageDevicesResponse(
    deviceDeploymentSummaries: Iterable[
      zio.aws.sagemaker.model.DeviceDeploymentSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse = {
    import ListStageDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse
      .builder()
      .deviceDeploymentSummaries(deviceDeploymentSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListStageDevicesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListStageDevicesResponse.wrap(buildAwsValue())
}
object ListStageDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListStageDevicesResponse =
      zio.aws.sagemaker.model.ListStageDevicesResponse(
        deviceDeploymentSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def deviceDeploymentSummaries
        : List[zio.aws.sagemaker.model.DeviceDeploymentSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDeviceDeploymentSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.DeviceDeploymentSummary.ReadOnly
    ]] = ZIO.succeed(deviceDeploymentSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse
  ) extends zio.aws.sagemaker.model.ListStageDevicesResponse.ReadOnly {
    override val deviceDeploymentSummaries
        : List[zio.aws.sagemaker.model.DeviceDeploymentSummary.ReadOnly] = impl
      .deviceDeploymentSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.DeviceDeploymentSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse
  ): zio.aws.sagemaker.model.ListStageDevicesResponse.ReadOnly = new Wrapper(
    impl
  )
}
