package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  MaxResults,
  ImageVersionNumber,
  ImageName,
  SageMakerImageVersionAlias
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAliasesRequest(
    imageName: ImageName,
    alias: Optional[SageMakerImageVersionAlias] = Optional.Absent,
    version: Optional[ImageVersionNumber] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest = {
    import ListAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest
      .builder()
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .optionallyWith(
        alias.map(value =>
          SageMakerImageVersionAlias.unwrap(value): java.lang.String
        )
      )(_.alias)
      .optionallyWith(
        version.map(value => ImageVersionNumber.unwrap(value): Integer)
      )(_.version)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAliasesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListAliasesRequest.wrap(buildAwsValue())
}
object ListAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAliasesRequest =
      zio.aws.sagemaker.model.ListAliasesRequest(
        imageName,
        alias.map(value => value),
        version.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def imageName: ImageName
    def alias: Optional[SageMakerImageVersionAlias]
    def version: Optional[ImageVersionNumber]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getAlias: ZIO[Any, AwsError, SageMakerImageVersionAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getVersion: ZIO[Any, AwsError, ImageVersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest
  ) extends zio.aws.sagemaker.model.ListAliasesRequest.ReadOnly {
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val alias: Optional[SageMakerImageVersionAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.sagemaker.model.primitives.SageMakerImageVersionAlias(value)
        )
    override val version: Optional[ImageVersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ImageVersionNumber(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest
  ): zio.aws.sagemaker.model.ListAliasesRequest.ReadOnly = new Wrapper(impl)
}
