package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait LastUpdateStatusValue {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue
}
object LastUpdateStatusValue {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue
  ): zio.aws.sagemaker.model.LastUpdateStatusValue = value match {
    case software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue.SUCCESSFUL =>
      val r = Successful
      r
    case software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue.IN_PROGRESS =>
      val r = InProgress
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.LastUpdateStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue =
      software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue.UNKNOWN_TO_SDK_VERSION
  }
  case object Successful extends zio.aws.sagemaker.model.LastUpdateStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue =
      software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue.SUCCESSFUL
  }
  case object Failed extends zio.aws.sagemaker.model.LastUpdateStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue =
      software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue.FAILED
  }
  case object InProgress extends zio.aws.sagemaker.model.LastUpdateStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue =
      software.amazon.awssdk.services.sagemaker.model.LastUpdateStatusValue.IN_PROGRESS
  }
}
