package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeploymentRecommendation(
    recommendationStatus: zio.aws.sagemaker.model.RecommendationStatus,
    realTimeInferenceRecommendations: Optional[
      Iterable[zio.aws.sagemaker.model.RealTimeInferenceRecommendation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeploymentRecommendation = {
    import DeploymentRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeploymentRecommendation
      .builder()
      .recommendationStatus(recommendationStatus.unwrap)
      .optionallyWith(
        realTimeInferenceRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.realTimeInferenceRecommendations)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeploymentRecommendation.ReadOnly =
    zio.aws.sagemaker.model.DeploymentRecommendation.wrap(buildAwsValue())
}
object DeploymentRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeploymentRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeploymentRecommendation =
      zio.aws.sagemaker.model.DeploymentRecommendation(
        recommendationStatus,
        realTimeInferenceRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def recommendationStatus: zio.aws.sagemaker.model.RecommendationStatus
    def realTimeInferenceRecommendations: Optional[
      List[zio.aws.sagemaker.model.RealTimeInferenceRecommendation.ReadOnly]
    ]
    def getRecommendationStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RecommendationStatus] =
      ZIO.succeed(recommendationStatus)
    def getRealTimeInferenceRecommendations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.RealTimeInferenceRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "realTimeInferenceRecommendations",
      realTimeInferenceRecommendations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentRecommendation
  ) extends zio.aws.sagemaker.model.DeploymentRecommendation.ReadOnly {
    override val recommendationStatus
        : zio.aws.sagemaker.model.RecommendationStatus =
      zio.aws.sagemaker.model.RecommendationStatus
        .wrap(impl.recommendationStatus())
    override val realTimeInferenceRecommendations: Optional[
      List[zio.aws.sagemaker.model.RealTimeInferenceRecommendation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.realTimeInferenceRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.RealTimeInferenceRecommendation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentRecommendation
  ): zio.aws.sagemaker.model.DeploymentRecommendation.ReadOnly = new Wrapper(
    impl
  )
}
