package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class DeleteEdgeDeploymentPlanRequest(
    edgeDeploymentPlanName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest = {
    import DeleteEdgeDeploymentPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest
      .builder()
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteEdgeDeploymentPlanRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteEdgeDeploymentPlanRequest
      .wrap(buildAwsValue())
}
object DeleteEdgeDeploymentPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteEdgeDeploymentPlanRequest =
      zio.aws.sagemaker.model
        .DeleteEdgeDeploymentPlanRequest(edgeDeploymentPlanName)
    def edgeDeploymentPlanName: EntityName
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest
  ) extends zio.aws.sagemaker.model.DeleteEdgeDeploymentPlanRequest.ReadOnly {
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest
  ): zio.aws.sagemaker.model.DeleteEdgeDeploymentPlanRequest.ReadOnly =
    new Wrapper(impl)
}
