package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ArtifactArn
import scala.jdk.CollectionConverters._
final case class DeleteArtifactResponse(
    artifactArn: Optional[ArtifactArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse = {
    import DeleteArtifactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse
      .builder()
      .optionallyWith(
        artifactArn.map(value => ArtifactArn.unwrap(value): java.lang.String)
      )(_.artifactArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly =
    zio.aws.sagemaker.model.DeleteArtifactResponse.wrap(buildAwsValue())
}
object DeleteArtifactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteArtifactResponse =
      zio.aws.sagemaker.model
        .DeleteArtifactResponse(artifactArn.map(value => value))
    def artifactArn: Optional[ArtifactArn]
    def getArtifactArn: ZIO[Any, AwsError, ArtifactArn] =
      AwsError.unwrapOptionField("artifactArn", artifactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse
  ) extends zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly {
    override val artifactArn: Optional[ArtifactArn] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactArn())
      .map(value => zio.aws.sagemaker.model.primitives.ArtifactArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse
  ): zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly = new Wrapper(impl)
}
