package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class CreateCodeRepositoryRequest(
    codeRepositoryName: EntityName,
    gitConfig: zio.aws.sagemaker.model.GitConfig,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest = {
    import CreateCodeRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest
      .builder()
      .codeRepositoryName(
        EntityName.unwrap(codeRepositoryName): java.lang.String
      )
      .gitConfig(gitConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateCodeRepositoryRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateCodeRepositoryRequest.wrap(buildAwsValue())
}
object CreateCodeRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateCodeRepositoryRequest =
      zio.aws.sagemaker.model.CreateCodeRepositoryRequest(
        codeRepositoryName,
        gitConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def codeRepositoryName: EntityName
    def gitConfig: zio.aws.sagemaker.model.GitConfig.ReadOnly
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getCodeRepositoryName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(codeRepositoryName)
    def getGitConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.GitConfig.ReadOnly] =
      ZIO.succeed(gitConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest
  ) extends zio.aws.sagemaker.model.CreateCodeRepositoryRequest.ReadOnly {
    override val codeRepositoryName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.codeRepositoryName())
    override val gitConfig: zio.aws.sagemaker.model.GitConfig.ReadOnly =
      zio.aws.sagemaker.model.GitConfig.wrap(impl.gitConfig())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest
  ): zio.aws.sagemaker.model.CreateCodeRepositoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
