package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  InferenceExperimentDescription,
  InferenceExperimentName
}
import scala.jdk.CollectionConverters._
final case class UpdateInferenceExperimentRequest(
    name: InferenceExperimentName,
    schedule: Optional[zio.aws.sagemaker.model.InferenceExperimentSchedule] =
      Optional.Absent,
    description: Optional[InferenceExperimentDescription] = Optional.Absent,
    modelVariants: Optional[
      Iterable[zio.aws.sagemaker.model.ModelVariantConfig]
    ] = Optional.Absent,
    dataStorageConfig: Optional[
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig
    ] = Optional.Absent,
    shadowModeConfig: Optional[zio.aws.sagemaker.model.ShadowModeConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentRequest = {
    import UpdateInferenceExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentRequest
      .builder()
      .name(InferenceExperimentName.unwrap(name): java.lang.String)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        description.map(value =>
          InferenceExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        modelVariants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelVariants)
      .optionallyWith(dataStorageConfig.map(value => value.buildAwsValue()))(
        _.dataStorageConfig
      )
      .optionallyWith(shadowModeConfig.map(value => value.buildAwsValue()))(
        _.shadowModeConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateInferenceExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateInferenceExperimentRequest
      .wrap(buildAwsValue())
}
object UpdateInferenceExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateInferenceExperimentRequest =
      zio.aws.sagemaker.model.UpdateInferenceExperimentRequest(
        name,
        schedule.map(value => value.asEditable),
        description.map(value => value),
        modelVariants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataStorageConfig.map(value => value.asEditable),
        shadowModeConfig.map(value => value.asEditable)
      )
    def name: InferenceExperimentName
    def schedule
        : Optional[zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly]
    def description: Optional[InferenceExperimentDescription]
    def modelVariants
        : Optional[List[zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly]]
    def dataStorageConfig: Optional[
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly
    ]
    def shadowModeConfig
        : Optional[zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, InferenceExperimentName] = ZIO.succeed(name)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getDescription: ZIO[Any, AwsError, InferenceExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getModelVariants: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("modelVariants", modelVariants)
    def getDataStorageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataStorageConfig", dataStorageConfig)
    def getShadowModeConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly
    ] = AwsError.unwrapOptionField("shadowModeConfig", shadowModeConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentRequest
  ) extends zio.aws.sagemaker.model.UpdateInferenceExperimentRequest.ReadOnly {
    override val name: InferenceExperimentName =
      zio.aws.sagemaker.model.primitives.InferenceExperimentName(impl.name())
    override val schedule: Optional[
      zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schedule())
      .map(value =>
        zio.aws.sagemaker.model.InferenceExperimentSchedule.wrap(value)
      )
    override val description: Optional[InferenceExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .InferenceExperimentDescription(value)
        )
    override val modelVariants
        : Optional[List[zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelVariants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ModelVariantConfig.wrap(item)
          }.toList
        )
    override val dataStorageConfig: Optional[
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStorageConfig())
      .map(value =>
        zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.wrap(value)
      )
    override val shadowModeConfig
        : Optional[zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shadowModeConfig())
        .map(value => zio.aws.sagemaker.model.ShadowModeConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentRequest
  ): zio.aws.sagemaker.model.UpdateInferenceExperimentRequest.ReadOnly =
    new Wrapper(impl)
}
