package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TrainingRepositoryCredentialsProviderArn
import scala.jdk.CollectionConverters._
final case class TrainingRepositoryAuthConfig(
    trainingRepositoryCredentialsProviderArn: TrainingRepositoryCredentialsProviderArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAuthConfig = {
    import TrainingRepositoryAuthConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAuthConfig
      .builder()
      .trainingRepositoryCredentialsProviderArn(
        TrainingRepositoryCredentialsProviderArn.unwrap(
          trainingRepositoryCredentialsProviderArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.TrainingRepositoryAuthConfig.ReadOnly =
    zio.aws.sagemaker.model.TrainingRepositoryAuthConfig.wrap(buildAwsValue())
}
object TrainingRepositoryAuthConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAuthConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrainingRepositoryAuthConfig =
      zio.aws.sagemaker.model
        .TrainingRepositoryAuthConfig(trainingRepositoryCredentialsProviderArn)
    def trainingRepositoryCredentialsProviderArn
        : TrainingRepositoryCredentialsProviderArn
    def getTrainingRepositoryCredentialsProviderArn
        : ZIO[Any, Nothing, TrainingRepositoryCredentialsProviderArn] =
      ZIO.succeed(trainingRepositoryCredentialsProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAuthConfig
  ) extends zio.aws.sagemaker.model.TrainingRepositoryAuthConfig.ReadOnly {
    override val trainingRepositoryCredentialsProviderArn
        : TrainingRepositoryCredentialsProviderArn =
      zio.aws.sagemaker.model.primitives
        .TrainingRepositoryCredentialsProviderArn(
          impl.trainingRepositoryCredentialsProviderArn()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingRepositoryAuthConfig
  ): zio.aws.sagemaker.model.TrainingRepositoryAuthConfig.ReadOnly =
    new Wrapper(impl)
}
