package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait StageStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.StageStatus
}
object StageStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.StageStatus
  ): zio.aws.sagemaker.model.StageStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.StageStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.StageStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.sagemaker.model.StageStatus.READYTODEPLOY =>
      val r = READYTODEPLOY
      r
    case software.amazon.awssdk.services.sagemaker.model.StageStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.sagemaker.model.StageStatus.INPROGRESS =>
      val r = INPROGRESS
      r
    case software.amazon.awssdk.services.sagemaker.model.StageStatus.DEPLOYED =>
      val r = DEPLOYED
      r
    case software.amazon.awssdk.services.sagemaker.model.StageStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sagemaker.model.StageStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.sagemaker.model.StageStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.StageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StageStatus =
      software.amazon.awssdk.services.sagemaker.model.StageStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.sagemaker.model.StageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StageStatus =
      software.amazon.awssdk.services.sagemaker.model.StageStatus.CREATING
  }
  case object READYTODEPLOY extends zio.aws.sagemaker.model.StageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StageStatus =
      software.amazon.awssdk.services.sagemaker.model.StageStatus.READYTODEPLOY
  }
  case object STARTING extends zio.aws.sagemaker.model.StageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StageStatus =
      software.amazon.awssdk.services.sagemaker.model.StageStatus.STARTING
  }
  case object INPROGRESS extends zio.aws.sagemaker.model.StageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StageStatus =
      software.amazon.awssdk.services.sagemaker.model.StageStatus.INPROGRESS
  }
  case object DEPLOYED extends zio.aws.sagemaker.model.StageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StageStatus =
      software.amazon.awssdk.services.sagemaker.model.StageStatus.DEPLOYED
  }
  case object FAILED extends zio.aws.sagemaker.model.StageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StageStatus =
      software.amazon.awssdk.services.sagemaker.model.StageStatus.FAILED
  }
  case object STOPPING extends zio.aws.sagemaker.model.StageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StageStatus =
      software.amazon.awssdk.services.sagemaker.model.StageStatus.STOPPING
  }
  case object STOPPED extends zio.aws.sagemaker.model.StageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StageStatus =
      software.amazon.awssdk.services.sagemaker.model.StageStatus.STOPPED
  }
}
