package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.PropertyNameHint
import scala.jdk.CollectionConverters._
final case class PropertyNameQuery(propertyNameHint: PropertyNameHint) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PropertyNameQuery = {
    import PropertyNameQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PropertyNameQuery
      .builder()
      .propertyNameHint(
        PropertyNameHint.unwrap(propertyNameHint): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PropertyNameQuery.ReadOnly =
    zio.aws.sagemaker.model.PropertyNameQuery.wrap(buildAwsValue())
}
object PropertyNameQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PropertyNameQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PropertyNameQuery =
      zio.aws.sagemaker.model.PropertyNameQuery(propertyNameHint)
    def propertyNameHint: PropertyNameHint
    def getPropertyNameHint: ZIO[Any, Nothing, PropertyNameHint] =
      ZIO.succeed(propertyNameHint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PropertyNameQuery
  ) extends zio.aws.sagemaker.model.PropertyNameQuery.ReadOnly {
    override val propertyNameHint: PropertyNameHint =
      zio.aws.sagemaker.model.primitives
        .PropertyNameHint(impl.propertyNameHint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PropertyNameQuery
  ): zio.aws.sagemaker.model.PropertyNameQuery.ReadOnly = new Wrapper(impl)
}
