package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MonitoringInput(
    endpointInput: Optional[zio.aws.sagemaker.model.EndpointInput] =
      Optional.Absent,
    batchTransformInput: Optional[zio.aws.sagemaker.model.BatchTransformInput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringInput = {
    import MonitoringInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringInput
      .builder()
      .optionallyWith(endpointInput.map(value => value.buildAwsValue()))(
        _.endpointInput
      )
      .optionallyWith(batchTransformInput.map(value => value.buildAwsValue()))(
        _.batchTransformInput
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringInput.ReadOnly =
    zio.aws.sagemaker.model.MonitoringInput.wrap(buildAwsValue())
}
object MonitoringInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringInput =
      zio.aws.sagemaker.model.MonitoringInput(
        endpointInput.map(value => value.asEditable),
        batchTransformInput.map(value => value.asEditable)
      )
    def endpointInput: Optional[zio.aws.sagemaker.model.EndpointInput.ReadOnly]
    def batchTransformInput
        : Optional[zio.aws.sagemaker.model.BatchTransformInput.ReadOnly]
    def getEndpointInput
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.EndpointInput.ReadOnly] =
      AwsError.unwrapOptionField("endpointInput", endpointInput)
    def getBatchTransformInput: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.BatchTransformInput.ReadOnly
    ] = AwsError.unwrapOptionField("batchTransformInput", batchTransformInput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringInput
  ) extends zio.aws.sagemaker.model.MonitoringInput.ReadOnly {
    override val endpointInput
        : Optional[zio.aws.sagemaker.model.EndpointInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointInput())
        .map(value => zio.aws.sagemaker.model.EndpointInput.wrap(value))
    override val batchTransformInput
        : Optional[zio.aws.sagemaker.model.BatchTransformInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchTransformInput())
        .map(value => zio.aws.sagemaker.model.BatchTransformInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringInput
  ): zio.aws.sagemaker.model.MonitoringInput.ReadOnly = new Wrapper(impl)
}
