package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ModelCardSortOrder {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder
}
object ModelCardSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder
  ): zio.aws.sagemaker.model.ModelCardSortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelCardSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending extends zio.aws.sagemaker.model.ModelCardSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder.ASCENDING
  }
  case object Descending extends zio.aws.sagemaker.model.ModelCardSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ModelCardSortOrder.DESCENDING
  }
}
