package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  EntityName,
  ListMaxResults,
  NextToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStageDevicesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListMaxResults] = Optional.Absent,
    edgeDeploymentPlanName: EntityName,
    excludeDevicesDeployedInOtherStage: Optional[Boolean] = Optional.Absent,
    stageName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest = {
    import ListStageDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .optionallyWith(
        excludeDevicesDeployedInOtherStage.map(value =>
          value: java.lang.Boolean
        )
      )(_.excludeDevicesDeployedInOtherStage)
      .stageName(EntityName.unwrap(stageName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListStageDevicesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListStageDevicesRequest.wrap(buildAwsValue())
}
object ListStageDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListStageDevicesRequest =
      zio.aws.sagemaker.model.ListStageDevicesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        edgeDeploymentPlanName,
        excludeDevicesDeployedInOtherStage.map(value => value),
        stageName
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListMaxResults]
    def edgeDeploymentPlanName: EntityName
    def excludeDevicesDeployedInOtherStage: Optional[Boolean]
    def stageName: EntityName
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
    def getExcludeDevicesDeployedInOtherStage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "excludeDevicesDeployedInOtherStage",
        excludeDevicesDeployedInOtherStage
      )
    def getStageName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest
  ) extends zio.aws.sagemaker.model.ListStageDevicesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[ListMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.ListMaxResults(value))
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
    override val excludeDevicesDeployedInOtherStage: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeDevicesDeployedInOtherStage())
        .map(value => value: Boolean)
    override val stageName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.stageName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest
  ): zio.aws.sagemaker.model.ListStageDevicesRequest.ReadOnly = new Wrapper(
    impl
  )
}
