package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListInferenceRecommendationsJobStepsResponse(
    steps: Optional[
      Iterable[zio.aws.sagemaker.model.InferenceRecommendationsJobStep]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse = {
    import ListInferenceRecommendationsJobStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse
      .builder()
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsResponse
      .wrap(buildAwsValue())
}
object ListInferenceRecommendationsJobStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsResponse =
      zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsResponse(
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def steps: Optional[
      List[zio.aws.sagemaker.model.InferenceRecommendationsJobStep.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSteps: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.InferenceRecommendationsJobStep.ReadOnly
    ]] = AwsError.unwrapOptionField("steps", steps)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse
  ) extends zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsResponse.ReadOnly {
    override val steps: Optional[
      List[zio.aws.sagemaker.model.InferenceRecommendationsJobStep.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.steps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.InferenceRecommendationsJobStep.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse
  ): zio.aws.sagemaker.model.ListInferenceRecommendationsJobStepsResponse.ReadOnly =
    new Wrapper(impl)
}
