package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HyperParameterTuningJobWarmStartConfig(
    parentHyperParameterTuningJobs: Iterable[
      zio.aws.sagemaker.model.ParentHyperParameterTuningJob
    ],
    warmStartType: zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig = {
    import HyperParameterTuningJobWarmStartConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig
      .builder()
      .parentHyperParameterTuningJobs(parentHyperParameterTuningJobs.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .warmStartType(warmStartType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig
      .wrap(buildAwsValue())
}
object HyperParameterTuningJobWarmStartConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig =
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig(
        parentHyperParameterTuningJobs.map { item =>
          item.asEditable
        },
        warmStartType
      )
    def parentHyperParameterTuningJobs
        : List[zio.aws.sagemaker.model.ParentHyperParameterTuningJob.ReadOnly]
    def warmStartType
        : zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartType
    def getParentHyperParameterTuningJobs: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ParentHyperParameterTuningJob.ReadOnly
    ]] = ZIO.succeed(parentHyperParameterTuningJobs)
    def getWarmStartType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartType
    ] = ZIO.succeed(warmStartType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig
  ) extends zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly {
    override val parentHyperParameterTuningJobs
        : List[zio.aws.sagemaker.model.ParentHyperParameterTuningJob.ReadOnly] =
      impl
        .parentHyperParameterTuningJobs()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.ParentHyperParameterTuningJob.wrap(item)
        }
        .toList
    override val warmStartType
        : zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartType =
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartType
        .wrap(impl.warmStartType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig
  ): zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly =
    new Wrapper(impl)
}
