package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait EndpointSortKey {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.EndpointSortKey
}
object EndpointSortKey {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.EndpointSortKey
  ): zio.aws.sagemaker.model.EndpointSortKey = value match {
    case software.amazon.awssdk.services.sagemaker.model.EndpointSortKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointSortKey.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointSortKey.CREATION_TIME =>
      val r = CreationTime
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointSortKey.STATUS =>
      val r = Status
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.EndpointSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointSortKey =
      software.amazon.awssdk.services.sagemaker.model.EndpointSortKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.sagemaker.model.EndpointSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointSortKey =
      software.amazon.awssdk.services.sagemaker.model.EndpointSortKey.NAME
  }
  case object CreationTime extends zio.aws.sagemaker.model.EndpointSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointSortKey =
      software.amazon.awssdk.services.sagemaker.model.EndpointSortKey.CREATION_TIME
  }
  case object Status extends zio.aws.sagemaker.model.EndpointSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointSortKey =
      software.amazon.awssdk.services.sagemaker.model.EndpointSortKey.STATUS
  }
}
