package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait EdgePackagingJobStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus
}
object EdgePackagingJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus
  ): zio.aws.sagemaker.model.EdgePackagingJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.INPROGRESS =>
      val r = INPROGRESS
      r
    case software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.EdgePackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTING extends zio.aws.sagemaker.model.EdgePackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.STARTING
  }
  case object INPROGRESS
      extends zio.aws.sagemaker.model.EdgePackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.INPROGRESS
  }
  case object COMPLETED extends zio.aws.sagemaker.model.EdgePackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.COMPLETED
  }
  case object FAILED extends zio.aws.sagemaker.model.EdgePackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.FAILED
  }
  case object STOPPING extends zio.aws.sagemaker.model.EdgePackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.STOPPING
  }
  case object STOPPED extends zio.aws.sagemaker.model.EdgePackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus.STOPPED
  }
}
