package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{EdgeVersion, EntityName}
import scala.jdk.CollectionConverters._
final case class EdgeModelSummary(
    modelName: EntityName,
    modelVersion: EdgeVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgeModelSummary = {
    import EdgeModelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgeModelSummary
      .builder()
      .modelName(EntityName.unwrap(modelName): java.lang.String)
      .modelVersion(EdgeVersion.unwrap(modelVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgeModelSummary.ReadOnly =
    zio.aws.sagemaker.model.EdgeModelSummary.wrap(buildAwsValue())
}
object EdgeModelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgeModelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgeModelSummary =
      zio.aws.sagemaker.model.EdgeModelSummary(modelName, modelVersion)
    def modelName: EntityName
    def modelVersion: EdgeVersion
    def getModelName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(modelName)
    def getModelVersion: ZIO[Any, Nothing, EdgeVersion] =
      ZIO.succeed(modelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeModelSummary
  ) extends zio.aws.sagemaker.model.EdgeModelSummary.ReadOnly {
    override val modelName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelName())
    override val modelVersion: EdgeVersion =
      zio.aws.sagemaker.model.primitives.EdgeVersion(impl.modelVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeModelSummary
  ): zio.aws.sagemaker.model.EdgeModelSummary.ReadOnly = new Wrapper(impl)
}
