package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  AppImageConfigName,
  ImageVersionNumber,
  ImageName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CustomImage(
    imageName: ImageName,
    imageVersionNumber: Optional[ImageVersionNumber] = Optional.Absent,
    appImageConfigName: AppImageConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CustomImage = {
    import CustomImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CustomImage
      .builder()
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .optionallyWith(
        imageVersionNumber.map(value =>
          ImageVersionNumber.unwrap(value): Integer
        )
      )(_.imageVersionNumber)
      .appImageConfigName(
        AppImageConfigName.unwrap(appImageConfigName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CustomImage.ReadOnly =
    zio.aws.sagemaker.model.CustomImage.wrap(buildAwsValue())
}
object CustomImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CustomImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CustomImage =
      zio.aws.sagemaker.model.CustomImage(
        imageName,
        imageVersionNumber.map(value => value),
        appImageConfigName
      )
    def imageName: ImageName
    def imageVersionNumber: Optional[ImageVersionNumber]
    def appImageConfigName: AppImageConfigName
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getImageVersionNumber: ZIO[Any, AwsError, ImageVersionNumber] =
      AwsError.unwrapOptionField("imageVersionNumber", imageVersionNumber)
    def getAppImageConfigName: ZIO[Any, Nothing, AppImageConfigName] =
      ZIO.succeed(appImageConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CustomImage
  ) extends zio.aws.sagemaker.model.CustomImage.ReadOnly {
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val imageVersionNumber: Optional[ImageVersionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageVersionNumber())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ImageVersionNumber(value)
        )
    override val appImageConfigName: AppImageConfigName =
      zio.aws.sagemaker.model.primitives
        .AppImageConfigName(impl.appImageConfigName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CustomImage
  ): zio.aws.sagemaker.model.CustomImage.ReadOnly = new Wrapper(impl)
}
