package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.SpaceArn
import scala.jdk.CollectionConverters._
final case class CreateSpaceResponse(
    spaceArn: Optional[SpaceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateSpaceResponse = {
    import CreateSpaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateSpaceResponse
      .builder()
      .optionallyWith(
        spaceArn.map(value => SpaceArn.unwrap(value): java.lang.String)
      )(_.spaceArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateSpaceResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateSpaceResponse.wrap(buildAwsValue())
}
object CreateSpaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateSpaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateSpaceResponse =
      zio.aws.sagemaker.model.CreateSpaceResponse(spaceArn.map(value => value))
    def spaceArn: Optional[SpaceArn]
    def getSpaceArn: ZIO[Any, AwsError, SpaceArn] =
      AwsError.unwrapOptionField("spaceArn", spaceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateSpaceResponse
  ) extends zio.aws.sagemaker.model.CreateSpaceResponse.ReadOnly {
    override val spaceArn: Optional[SpaceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceArn())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateSpaceResponse
  ): zio.aws.sagemaker.model.CreateSpaceResponse.ReadOnly = new Wrapper(impl)
}
