package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{String1024, DomainArn}
import scala.jdk.CollectionConverters._
final case class CreateDomainResponse(
    domainArn: Optional[DomainArn] = Optional.Absent,
    url: Optional[String1024] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse = {
    import CreateDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse
      .builder()
      .optionallyWith(
        domainArn.map(value => DomainArn.unwrap(value): java.lang.String)
      )(_.domainArn)
      .optionallyWith(
        url.map(value => String1024.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateDomainResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateDomainResponse.wrap(buildAwsValue())
}
object CreateDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateDomainResponse =
      zio.aws.sagemaker.model.CreateDomainResponse(
        domainArn.map(value => value),
        url.map(value => value)
      )
    def domainArn: Optional[DomainArn]
    def url: Optional[String1024]
    def getDomainArn: ZIO[Any, AwsError, DomainArn] =
      AwsError.unwrapOptionField("domainArn", domainArn)
    def getUrl: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse
  ) extends zio.aws.sagemaker.model.CreateDomainResponse.ReadOnly {
    override val domainArn: Optional[DomainArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainArn())
      .map(value => zio.aws.sagemaker.model.primitives.DomainArn(value))
    override val url: Optional[String1024] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse
  ): zio.aws.sagemaker.model.CreateDomainResponse.ReadOnly = new Wrapper(impl)
}
