package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AutoMLProcessingUnit {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit
}
object AutoMLProcessingUnit {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit
  ): zio.aws.sagemaker.model.AutoMLProcessingUnit = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit.CPU =>
      val r = CPU
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit.GPU =>
      val r = GPU
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLProcessingUnit {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit =
      software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object CPU extends zio.aws.sagemaker.model.AutoMLProcessingUnit {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit =
      software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit.CPU
  }
  case object GPU extends zio.aws.sagemaker.model.AutoMLProcessingUnit {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit =
      software.amazon.awssdk.services.sagemaker.model.AutoMLProcessingUnit.GPU
  }
}
