package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoMLProblemTypeConfig(
    imageClassificationJobConfig: Optional[
      zio.aws.sagemaker.model.ImageClassificationJobConfig
    ] = Optional.Absent,
    textClassificationJobConfig: Optional[
      zio.aws.sagemaker.model.TextClassificationJobConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfig = {
    import AutoMLProblemTypeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfig
      .builder()
      .optionallyWith(
        imageClassificationJobConfig.map(value => value.buildAwsValue())
      )(_.imageClassificationJobConfig)
      .optionallyWith(
        textClassificationJobConfig.map(value => value.buildAwsValue())
      )(_.textClassificationJobConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLProblemTypeConfig.ReadOnly =
    zio.aws.sagemaker.model.AutoMLProblemTypeConfig.wrap(buildAwsValue())
}
object AutoMLProblemTypeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLProblemTypeConfig =
      zio.aws.sagemaker.model.AutoMLProblemTypeConfig(
        imageClassificationJobConfig.map(value => value.asEditable),
        textClassificationJobConfig.map(value => value.asEditable)
      )
    def imageClassificationJobConfig: Optional[
      zio.aws.sagemaker.model.ImageClassificationJobConfig.ReadOnly
    ]
    def textClassificationJobConfig
        : Optional[zio.aws.sagemaker.model.TextClassificationJobConfig.ReadOnly]
    def getImageClassificationJobConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ImageClassificationJobConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageClassificationJobConfig",
      imageClassificationJobConfig
    )
    def getTextClassificationJobConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TextClassificationJobConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "textClassificationJobConfig",
      textClassificationJobConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfig
  ) extends zio.aws.sagemaker.model.AutoMLProblemTypeConfig.ReadOnly {
    override val imageClassificationJobConfig: Optional[
      zio.aws.sagemaker.model.ImageClassificationJobConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageClassificationJobConfig())
      .map(value =>
        zio.aws.sagemaker.model.ImageClassificationJobConfig.wrap(value)
      )
    override val textClassificationJobConfig: Optional[
      zio.aws.sagemaker.model.TextClassificationJobConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.textClassificationJobConfig())
      .map(value =>
        zio.aws.sagemaker.model.TextClassificationJobConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeConfig
  ): zio.aws.sagemaker.model.AutoMLProblemTypeConfig.ReadOnly = new Wrapper(
    impl
  )
}
