package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AutoMLAlgorithm {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm
}
object AutoMLAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm
  ): zio.aws.sagemaker.model.AutoMLAlgorithm = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.XGBOOST =>
      val r = xgboost
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.LINEAR_LEARNER =>
      val r = `linear-learner`
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.MLP =>
      val r = mlp
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.LIGHTGBM =>
      val r = lightgbm
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.CATBOOST =>
      val r = catboost
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.RANDOMFOREST =>
      val r = randomforest
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.EXTRA_TREES =>
      val r = `extra-trees`
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.NN_TORCH =>
      val r = `nn-torch`
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.FASTAI =>
      val r = fastai
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object xgboost extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.XGBOOST
  }
  case object `linear-learner` extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.LINEAR_LEARNER
  }
  case object mlp extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.MLP
  }
  case object lightgbm extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.LIGHTGBM
  }
  case object catboost extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.CATBOOST
  }
  case object randomforest extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.RANDOMFOREST
  }
  case object `extra-trees` extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.EXTRA_TREES
  }
  case object `nn-torch` extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.NN_TORCH
  }
  case object fastai extends zio.aws.sagemaker.model.AutoMLAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm =
      software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithm.FASTAI
  }
}
