package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AppInstanceType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AppInstanceType
}
object AppInstanceType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AppInstanceType
  ): zio.aws.sagemaker.model.AppInstanceType = value match {
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.SYSTEM =>
      val r = system
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_MICRO =>
      val r = `ml.t3.micro`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_SMALL =>
      val r = `ml.t3.small`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_MEDIUM =>
      val r = `ml.t3.medium`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_LARGE =>
      val r = `ml.t3.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_XLARGE =>
      val r = `ml.t3.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_2_XLARGE =>
      val r = `ml.t3.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_LARGE =>
      val r = `ml.m5.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_XLARGE =>
      val r = `ml.m5.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_2_XLARGE =>
      val r = `ml.m5.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_4_XLARGE =>
      val r = `ml.m5.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_8_XLARGE =>
      val r = `ml.m5.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_12_XLARGE =>
      val r = `ml.m5.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_16_XLARGE =>
      val r = `ml.m5.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_24_XLARGE =>
      val r = `ml.m5.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_LARGE =>
      val r = `ml.m5d.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_XLARGE =>
      val r = `ml.m5d.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_2_XLARGE =>
      val r = `ml.m5d.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_4_XLARGE =>
      val r = `ml.m5d.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_8_XLARGE =>
      val r = `ml.m5d.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_12_XLARGE =>
      val r = `ml.m5d.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_16_XLARGE =>
      val r = `ml.m5d.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_24_XLARGE =>
      val r = `ml.m5d.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_LARGE =>
      val r = `ml.c5.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_XLARGE =>
      val r = `ml.c5.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_2_XLARGE =>
      val r = `ml.c5.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_4_XLARGE =>
      val r = `ml.c5.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_9_XLARGE =>
      val r = `ml.c5.9xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_12_XLARGE =>
      val r = `ml.c5.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_18_XLARGE =>
      val r = `ml.c5.18xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_24_XLARGE =>
      val r = `ml.c5.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P3_2_XLARGE =>
      val r = `ml.p3.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P3_8_XLARGE =>
      val r = `ml.p3.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P3_16_XLARGE =>
      val r = `ml.p3.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P3_DN_24_XLARGE =>
      val r = `ml.p3dn.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_XLARGE =>
      val r = `ml.g4dn.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_2_XLARGE =>
      val r = `ml.g4dn.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_4_XLARGE =>
      val r = `ml.g4dn.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_8_XLARGE =>
      val r = `ml.g4dn.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_12_XLARGE =>
      val r = `ml.g4dn.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_16_XLARGE =>
      val r = `ml.g4dn.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_LARGE =>
      val r = `ml.r5.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_XLARGE =>
      val r = `ml.r5.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_2_XLARGE =>
      val r = `ml.r5.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_4_XLARGE =>
      val r = `ml.r5.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_8_XLARGE =>
      val r = `ml.r5.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_12_XLARGE =>
      val r = `ml.r5.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_16_XLARGE =>
      val r = `ml.r5.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_24_XLARGE =>
      val r = `ml.r5.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_XLARGE =>
      val r = `ml.g5.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_2_XLARGE =>
      val r = `ml.g5.2xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_4_XLARGE =>
      val r = `ml.g5.4xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_8_XLARGE =>
      val r = `ml.g5.8xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_16_XLARGE =>
      val r = `ml.g5.16xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_12_XLARGE =>
      val r = `ml.g5.12xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_24_XLARGE =>
      val r = `ml.g5.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_48_XLARGE =>
      val r = `ml.g5.48xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_GEOSPATIAL_INTERACTIVE =>
      val r = `ml.geospatial.interactive`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P4_D_24_XLARGE =>
      val r = `ml.p4d.24xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P4_DE_24_XLARGE =>
      val r = `ml.p4de.24xlarge`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object system extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.SYSTEM
  }
  case object `ml.t3.micro` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_MICRO
  }
  case object `ml.t3.small` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_SMALL
  }
  case object `ml.t3.medium` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_MEDIUM
  }
  case object `ml.t3.large` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_LARGE
  }
  case object `ml.t3.xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_XLARGE
  }
  case object `ml.t3.2xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_T3_2_XLARGE
  }
  case object `ml.m5.large` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_LARGE
  }
  case object `ml.m5.xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_XLARGE
  }
  case object `ml.m5.2xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_2_XLARGE
  }
  case object `ml.m5.4xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_4_XLARGE
  }
  case object `ml.m5.8xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_8_XLARGE
  }
  case object `ml.m5.12xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_12_XLARGE
  }
  case object `ml.m5.16xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_16_XLARGE
  }
  case object `ml.m5.24xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_24_XLARGE
  }
  case object `ml.m5d.large` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_LARGE
  }
  case object `ml.m5d.xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_XLARGE
  }
  case object `ml.m5d.2xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_2_XLARGE
  }
  case object `ml.m5d.4xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_4_XLARGE
  }
  case object `ml.m5d.8xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_8_XLARGE
  }
  case object `ml.m5d.12xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_12_XLARGE
  }
  case object `ml.m5d.16xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_16_XLARGE
  }
  case object `ml.m5d.24xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_M5_D_24_XLARGE
  }
  case object `ml.c5.large` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_LARGE
  }
  case object `ml.c5.xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_XLARGE
  }
  case object `ml.c5.2xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_2_XLARGE
  }
  case object `ml.c5.4xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_4_XLARGE
  }
  case object `ml.c5.9xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_9_XLARGE
  }
  case object `ml.c5.12xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_12_XLARGE
  }
  case object `ml.c5.18xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_18_XLARGE
  }
  case object `ml.c5.24xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_C5_24_XLARGE
  }
  case object `ml.p3.2xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P3_2_XLARGE
  }
  case object `ml.p3.8xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P3_8_XLARGE
  }
  case object `ml.p3.16xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P3_16_XLARGE
  }
  case object `ml.p3dn.24xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P3_DN_24_XLARGE
  }
  case object `ml.g4dn.xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_XLARGE
  }
  case object `ml.g4dn.2xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_2_XLARGE
  }
  case object `ml.g4dn.4xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_4_XLARGE
  }
  case object `ml.g4dn.8xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_8_XLARGE
  }
  case object `ml.g4dn.12xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_12_XLARGE
  }
  case object `ml.g4dn.16xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G4_DN_16_XLARGE
  }
  case object `ml.r5.large` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_LARGE
  }
  case object `ml.r5.xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_XLARGE
  }
  case object `ml.r5.2xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_2_XLARGE
  }
  case object `ml.r5.4xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_4_XLARGE
  }
  case object `ml.r5.8xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_8_XLARGE
  }
  case object `ml.r5.12xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_12_XLARGE
  }
  case object `ml.r5.16xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_16_XLARGE
  }
  case object `ml.r5.24xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_R5_24_XLARGE
  }
  case object `ml.g5.xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_XLARGE
  }
  case object `ml.g5.2xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_2_XLARGE
  }
  case object `ml.g5.4xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_4_XLARGE
  }
  case object `ml.g5.8xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_8_XLARGE
  }
  case object `ml.g5.16xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_16_XLARGE
  }
  case object `ml.g5.12xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_12_XLARGE
  }
  case object `ml.g5.24xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_24_XLARGE
  }
  case object `ml.g5.48xlarge` extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_G5_48_XLARGE
  }
  case object `ml.geospatial.interactive`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_GEOSPATIAL_INTERACTIVE
  }
  case object `ml.p4d.24xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P4_D_24_XLARGE
  }
  case object `ml.p4de.24xlarge`
      extends zio.aws.sagemaker.model.AppInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppInstanceType =
      software.amazon.awssdk.services.sagemaker.model.AppInstanceType.ML_P4_DE_24_XLARGE
  }
}
